#ifndef _TEXTURE_H_
#define _TEXTURE_H_

#include <stdio.h>
#include <stdlib.h>

#include "couleur.h"

using namespace std;

// Gestion d'une classe Texture
// Ne gre pour le moment que les formats .tga

class Texture
{
protected:
	SpectrePuiss*	buffer;			// Buffer d'image
	int				width;			// nb de colonnes 
	int				height;			// nb de lignes

public:
	Texture();
	Texture(char*);
	~Texture();

	SpectrePuiss* getBuffer() const;
	int getWidth() const;
	int getHeight() const;

	// Permet de rcuprer la valeur du texel dans le repre texture [0., 1.]
	SpectrePuiss getTexel(const float& u, const float& v) const;
};

Texture::Texture()
{
	buffer = NULL;
}

Texture::Texture(char* tex_name)
{
	buffer = NULL;

	if(tex_name)
	{
		FILE* f = fopen( tex_name, "rb" );
		if (f)
		{
			unsigned char buf[20];
			fread( buf, 1, 20, f );
			width = *(buf + 12) + 256 * *(buf + 13);
			height = *(buf + 14) + 256 * *(buf + 15);
			fclose( f );

			f = fopen(tex_name , "rb" );
			unsigned char* t = new unsigned char[width * height * 3 + 1024];
			fread( t, 1, width * height * 3 + 1024, f );
			fclose( f );
			buffer = new SpectrePuiss[width * height];
			float rec = 1.0f / 256.0f;
			for ( int size = width * height, i = 0; i < size; i++ )
				*(buffer+i) = SpectrePuiss( t[i * 3 + 20] * rec, t[i * 3 + 19] * rec, t[i * 3 + 18] * rec );
			delete t;
		}
	}
}

Texture::~Texture()
{
	if(buffer)
		delete[] buffer;
	buffer = NULL;
}

SpectrePuiss* Texture::getBuffer() const
{
	return buffer;
}

int Texture::getWidth() const
{
	return width;
}

int Texture::getHeight() const
{
	return height;
}

SpectrePuiss Texture::getTexel(const float& u, const float& v) const
{
	float fu = (u + 1000.5f) * width;
	float fv = (v + 1000.0f) * width;
	int u1 = ((int)fu) % width;
	int v1 = ((int)fv) % height;
	int u2 = (u1 + 1) % width;
	int v2 = (v1 + 1) % height;

	float fracu = fu - floorf( fu );
	float fracv = fv - floorf( fv );

	float w1 = (1 - fracu) * (1 - fracv);
	float w2 = fracu * (1 - fracv);
	float w3 = (1 - fracu) * fracv;
	float w4 = fracu *  fracv;

	SpectrePuiss c1 = buffer[u1 + v1 * width];
	SpectrePuiss c2 = buffer[u2 + v1 * width];
	SpectrePuiss c3 = buffer[u1 + v2 * width];
	SpectrePuiss c4 = buffer[u2 + v2 * width];

	return c1 * w1 + c2 * w2 + c3 * w3 + c4 * w4;
}

#endif // _TEXTURE_H_
