#ifndef _SCENE_H_
#define _SCENE_H_

#include <string>
#include <iostream>
#include <fstream>
#include <list>

#include "define.h"
#include "lampe.h"
#include "objet.h"
#include "camera.h"
#include "rayon.h"

using namespace std;

bool saveppm(const Film<RGB> &F, char *basename)
              { string fn=basename;

ofstream f((fn+".ppm").c_str(),ios::binary);
              if (!f.fail())
                     { f << "P6\n" << F.nc << " " << F.nl <<  "\n255\n";
                       f.write((char *)(F.image),F.nc*F.nl*sizeof(RGB));
                       return true;
                     }
              return false;
              }

class Scene
{
	protected:
		Camera*				activeCam;		// Camera active
		list<Lampe*>		lLamp;			// Lampes de la scene
		list<Objet>			lObj;			// Tous les objets de la scene (forme+repere+...)
		list<Film<RGB>* >	lFilm;			// Les films pour "enregistrer" la scne
		list<Camera*>		lCam;			// Les camras prsentes dans la scne (mais pas forcment active)

	public:
		Scene();
		Scene(Lampe* lp, const Objet& _o, Camera* cam, Film<RGB>* _f);

		void addObjet(const Objet&);
		void addCamera(Camera*);
		void addFilm(Film<RGB>*);
		void addLampe(Lampe*);
		void setActiveCam(unsigned num_camera);
		Objet* traceRayon(const Rayon&, SpectrePuiss&, float&, int recur);
		
		void Rendu();
};

Scene::Scene() : lLamp(), lObj(), lFilm(), lCam()
{
	activeCam = NULL;
}

Scene::Scene(Lampe* lp, const Objet& _o, Camera* cam, Film<RGB>* _f)
{
	lLamp.push_back(lp);
	lObj.push_back(_o);
	lCam.push_back(cam);
	lFilm.push_back(_f);

	activeCam = lCam.front();
}

void Scene::addObjet(const Objet& o)
{
	lObj.push_back(o);
}

void Scene::addCamera(Camera* c)
{
	lCam.push_back(c);

	if(!activeCam)
		activeCam = lCam.front();
}

void Scene::addFilm(Film<RGB>* f)
{
	lFilm.push_back(f);
}

void Scene::addLampe(Lampe* l)
{
	lLamp.push_back(l);
}

void Scene::setActiveCam(unsigned num_camera)
{}

Objet* Scene::traceRayon(const Rayon & Ray, SpectrePuiss& accum, float& dist, int recur)
{
	if(recur >= 10)
		return NULL;

	float shade = 1.0f;
	dist = 1000000.0f;
	vR3 pi;
	Objet* prim = NULL;
	float res;
	bool inside(false);

	// On cherche la premire intersection
	// De ce fait, ZBuffer est implicite (on ne cherche pas les autres intersections)

	for(list<Objet>::iterator it_obj=lObj.begin();it_obj!=lObj.end();it_obj++)
	{
		res = (*it_obj).inter(Ray);
		float res2 = res*res;

		if(res2 > eps2 &&  res2 < dist*dist) 
		{
			prim = &(*it_obj);
			dist = fabs(res);
			if(res < 0.0f)
				inside = true;
		}
	}

	if(!prim)
		return NULL;

	//Pt d'intersection: O+t*D

		pi = Ray.O + Ray.D * dist;

		// Composante ambiante

		accum = accum + prim->Prop(pi).Ka * prim->Prop(pi).filtre;

		// Application du rendu pour toutes les lampes de la scne

		for(list<Lampe*>::iterator it_lamp=lLamp.begin();it_lamp!=lLamp.end();it_lamp++)
		{
			shade = 1.0f;
			vR3 L = ((*it_lamp)->rPropreInv.O) - pi;
			float dist2lamp(Norme(L)), ttmp;
			L = Unitaire(L);
			vR3 N = prim->normale(pi);
			Rayon Ray2shade(pi, L);

			// On reparcourt les objets, pour savoir s'il y a une ombre porte

			for(list<Objet>::iterator it_tmp=lObj.begin();it_tmp!=lObj.end();it_tmp++)
				if((ttmp=(*it_tmp).inter(Ray2shade)) > eps && ttmp < dist2lamp && &(*it_tmp) != prim)
				{
					shade = 0.0f;
					break;
				}

			// Composante Diffuse ==> accumulation des du spectre de puissance
			// dans acc (Spectre puissance)

			if (prim->Prop(pi).Krd > 0.0f)
			{
					float dot = N % L;
					if(dot > 0.0f)
					{
						float diff = dot * prim->Prop(pi).Krd * shade;
						accum = accum + (prim->Prop(pi).filtre * diff) * (*it_lamp)->Recu(pi);
					}
			}

			// Tache(s) spculaires
			// Intraction si ombre porte
			// On se base sur le calcul du rayon R de reflxion spculaire (cf: rapport)
			// L ==> Vise

			if(prim->Prop(pi).Krs > 0.0f)
			{
					vR3 V = Ray.D;
					vR3 R = L - N * (2.0f *( L%N ));
					float dot = V % R;
					if (dot > 0.0f)
					{
						float spec = powf(dot, 8.0f) * prim->Prop(pi).Krs * shade;
						accum = accum + spec * (*it_lamp)->Recu(pi);
					}
			}
		}

		// Reflection (inter-objet)

		float refl = prim->Prop(pi).IndRefl;
		if (refl > 0.0f)
		{
			vR3 N = Unitaire(prim->normale(pi));
			vR3 R = Ray.D - N * 2.0f * (Ray.D % N);

			if (recur < 6) 
			{
				SpectrePuiss rcolb(0.0f, 0.0f, 0.0f);
				float dist_pp;
				Objet* obj_tmp = traceRayon(Rayon(pi+R*eps, R), rcolb, dist_pp, recur+1);

				if(obj_tmp && obj_tmp != prim )
					accum = accum + rcolb * prim->Prop(pi).filtre * refl;
			}
		}

		// Refraction (Yes !!!)
		// En plus de Whitted, nous utilisons la loi de Beer (exponentielle)

		float refr(prim->Prop(pi).IndRefr);

		if(refr > 0.0f && recur < 10)
		{
			float coeff(prim->Prop(pi).nspec);
			float nref(AIR_REFRACTION / coeff);		// On se base pour le moment  l'indice de rfraction de l'air
			vR3 N(prim->normale(pi));

			if(inside)			// Si nous sommes  l'intrieur de l'objet
				N = -N;
			
			// Rayon rfract lui-mme ==> rcursivit
			// Calcul de l'absorption du rayon par la matire

			float cosI(-(N%Ray.D));
			float cosT2(1.0f - nref*nref * (1.0f - cosI*cosI));

			if(cosT2 > eps2)
			{
				vR3 T((Ray.D*nref) + N*(nref * cosI - sqrtf(cosT2)));
				SpectrePuiss rcol(0.0f, 0.0f, 0.0f);
				float dist_p;
				Objet* obj_tmp2 = traceRayon(Rayon(pi+T*eps, T), rcol, dist_p, recur+1);	
				SpectrePuiss absorbance(prim->Prop(pi).filtre * 0.15f * (-dist_p));		
				SpectrePuiss transparency(expf(absorbance.r), expf(absorbance.g), expf(absorbance.b ));
				accum = accum + rcol*transparency;
			}
		}
		
	return prim;
}


// Rendu Phong avec ZBuffer et multi-obj
// ZBuffer implicite par lancer de rayon (premier intersection est prise en compte)
// Phong: Amb + Spec + Diff
// Whitted + Beer
// Ombres portes
// Textures 2D

void Scene::Rendu() 
{
	int m_Width(800), m_Height(800);
	vR3 o(0.0f, 0.0f, -5.0f);
	Film<RGB>* tempor = lFilm.front();
	RGB *buffer = tempor->image;
	int m_PPos(800*800-1);
	Repere R(pR3(0.0f, 0.0f, -15.0f));
	PinHole pin(36.0f, 24.0f, 25.0f, R);
	Quantif<SpectrePuiss, RGB>* Q = tempor->Q;
	float dist;

	for(float y(800.0f);y>0.0f;y-=(36.0f/24.0f))
	{
		for(float x(800.0f);x>0.0f;x-=1.0f)
		{
			SpectrePuiss acc( 0.0f, 0.0f, 0.0f );
			Rayon dir = pin.DemiDroite(pR2(x/((float)m_Height), y/((float)m_Width)));
			dir.D = Unitaire(dir.D);
	
			traceRayon( dir, acc, dist, 0);

			if(Q)
				buffer[m_PPos--] = Q->operator()(acc);
		}
	}
}

#endif // _SCENE_H_
