#ifndef REPERE_H_
#define REPERE_H_

#include "define.h"
#include "algebre.h"

class RepereDegenere {};
class Repere
  {
    public :   vR3 X,Y,Z; pR3 O;


    Repere (            ) : X(1,0,0), Y(0,1,0), Z(0,0,1), O(0,0,0) {}
    Repere (const pR3 &o) : X(1,0,0), Y(0,1,0), Z(0,0,1), O(o)     {}
    Repere (const vR3 &x,
            const vR3 &y,
            const vR3 &z) : X(x),     Y(y),     Z(z),     O(0,0,0) {}
    Repere (const vR3 &x,
            const vR3 &y,
            const vR3 &z,
            bool transpo) : X(x.x,y.x,z.x),
                            Y(x.y,y.y,z.y),
                            Z(x.z,y.z,z.z),     O(0,0,0) {}
	// paramtre transpo non utilis. Il sert seulement  diffrencier du constructeur prcdent
	// quelque soit sa valeur, la transposition aura lieu !!

    Repere (const vR3 &x,
            const vR3 &y,
            const vR3 &z,
            const pR3 &o) : X(x),     Y(y),     Z(z),     O(o)     {}

    pR3    operator * (const pR3    &p) const { return p.x*X+p.y*Y+p.z*Z+O; }
    vR3    operator * (const vR3    &v) const { return v.x*X+v.y*Y+v.z*Z;   }
    Repere operator * (const Repere &R) const { return Repere((*this)*R.X,
                                                              (*this)*R.Y,
                                                              (*this)*R.Z,
                                                              (*this)*R.O); }
    Repere Inverse () const throw (RepereDegenere)
      {
      float det= ProdMixte(X,Y,Z);
      if (det*det < eps2*(X%X)*(Y%Y)*(Z%Z)) throw RepereDegenere();
	  // test de volume de triedre (X,Y,Z) < eps * volume d'un tridre orthogonal de mmes dimensions d'axes

      Repere R(Y^Z/det,Z^X/det,X^Y/det,true);  R.O = - ( R*O);
	  // formule particulire de l'inverse d'une matrice 3x3

      return R;
      }
  };

  vR3 operator * (const vR3 &v, const Repere &R)
	{
	  return vR3(v%R.X, v%R.Y, v%R.Z); // vT.[R.X R.Y R.Z]
	}

#endif // REPERE_H_
