#ifndef _QUANTIF_H
#define _QUANTIF_H

#include "couleur.h"

template <class S, class D>
class Quantif { public : virtual D operator () (const S &s) const=0; };


// Dfinition de la classe Quantificateur en Noir & Blanc
// Utilise une fonction de luminace <=> (r+g+b)/3.

class QuantifNB : public Quantif<SpectrePuiss, RGB>
{
	public :
		 RGB operator ()(const SpectrePuiss& s) const;
};


// Quantificateur classique

class QuantifClassic : public Quantif<SpectrePuiss, RGB>
{
	public :
		 RGB operator ()(const SpectrePuiss& s) const;
};


// Quantificateur Sepia ==> permet d'obtenir l'effet Spia

class QuantifSepia : public Quantif<SpectrePuiss, RGB>
{
	public :
		 RGB operator ()(const SpectrePuiss& s) const;
};

RGB QuantifClassic::operator ()(const SpectrePuiss& s) const
{
	int red(s.r*255);
	int green(s.g*255);
	int blue(s.b*255);

	if(red > 255)
		red = 255;
	if(green > 255)
		green = 255;
	if(blue > 255)
		blue = 255;

	return RGB(red, green, blue);
}

RGB QuantifNB::operator ()(const SpectrePuiss& s) const
{
	int ndg(((s.r + s.g + s.b) / 3.0f)*255);

	if(ndg>255)
		ndg = 255;

	return RGB(ndg, ndg, ndg);
}


// Fonction de luminance avec des coefficients propres  cet effet

RGB QuantifSepia::operator ()(const SpectrePuiss& s) const
{
	float coul((s.r+s.g+s.b)/3.0f);
	SpectrePuiss bis(coul, coul*0.892f, coul*0.694f);

	return RGB(255*bis.r, 255*bis.g, 255*bis.b);
}

#endif //_QUANTIF_H
