#ifndef OBJET_H_
#define OBJET_H_

#include "repere.h"
#include "matiere.h"
#include "forme.h"
#include "texture.h"


class Objet
{		
		Forme   *F;
		Repere RDF, RIF; 
        Matiere *M;
		Repere RDM, RIM;
		Texture* tex;

	public :

        Objet (Forme   *f, const Repere &rf, Matiere *m, const Repere &rm) throw (RepereDegenere)
                 : F(f), RDF(rf), RIF(rf.Inverse()), M(m), RDM(rm), RIM(rm.Inverse())
        {
			tex = NULL;
		}

			float inter(const Rayon& R) const
			{
				  return F->inter(Rayon(RIF*R.O,RIF*R.D));
			}

			vR3   normale(const pR3 &p) const
			{
				  return F->normale(RIF*p)*RIF;
			}

			PropOpt Prop(const pR3 &p) const                  
			{
				if(!tex)
					return M->Prop(RIM*p);
				
				float u, v;

				PropOpt result(M->Prop(RIM*p));		// Proprits de matire de l'objet
				F->texCoords(RIF*p, RIM, u, v);		// On rcupre les coordonnes de texture selon le type de l'objet
				result.filtre = tex->getTexel(u, v) * result.filtre;	// Applique mlange couleur matire + valeur du texel

				return result;
			}

			void loadTexture(char* tex_name)
			{
				if(tex)
					delete tex;
				tex = new Texture(tex_name);
			}
};

#endif // OBJET_H_
