#ifndef MATIERE_H_
#define MATIERE_H_

#include "couleur.h"

class PropOpt
  { public : float Ka, Krs, Krd, Kts, Ktd, IndRefr, IndRefl, nspec; SpectrePuiss filtre;

    PropOpt (float a, float rs, float rd, float ts, float td, float ir, float irefl, float nsp,  
             SpectrePuiss filt) : Ka(a),Krs(rs),Krd(rd),Kts(ts),Ktd(td),
                                  IndRefr(ir), IndRefl(irefl), nspec(nsp),filtre(filt)
                                {}
  };

class Matiere
{
	public :
		virtual PropOpt Prop(const pR3 &p) const = 0;
};


class MatHom : public Matiere
{
	protected:
		PropOpt pOpt;

	public:
		MatHom(const PropOpt&);
		PropOpt Prop(const pR3 &p) const;
};

MatHom::MatHom(const PropOpt& _po) : pOpt(_po)
{}

PropOpt MatHom::Prop(const pR3& p) const
{
	return pOpt;
}

#endif // MATIERE_H_
