#ifndef S3D_YR
#define S3D_YR

#include <string>
#include <iostream>
#include <fstream>
#include <math.h>

#include "camera.h"
#include "forme.h"
#include "repere.h"
#include "couleur.h"
#include "algebre.h"
#include "objet.h"
#include "define.h"
#include "lampe.h"
#include "scene.h"

using namespace std;

int main_scene()
{
	Sphere sph(2.7f), sph2(2.7f);
	Plan plan(vR3(0.0f, -1.0f, 0.0f), 4.4f);
	Repere RTexSph(vR3(1., 0., 0.), vR3(0., 1., 0.), vR3(0., 1., 0.)^vR3(1., 0., 0.));
	Repere R(pR3(-3.5f, -0.5f, 4.0f)), RPlan(pR3(0., 1., 0.)), R2(pR3(3.5f, -0.5f, 2.0f)), RLampe(pR3(10.0f, 8.0f, 3.0f)), RLampe2(pR3(-10.0f, 8.0f, 3.0f)), RLampe3(pR3(0., 1.0, 8.0));
	Matiere *mat_rouge = new MatHom(PropOpt(0.1f, 0.4f, 0.6f, 0.2f, 0.4f, 0.0f, 0.0f, 0.0f, SpectrePuiss(0.6, 0.6, 0.6)));
	Matiere *m_sph2 = new MatHom(PropOpt(0.1f, 0.5f, 0.5f, 0.2f, 0.4f, 0.0f, 0.5f, 0.0f, SpectrePuiss(0.6, 0.6, 0.6)));
	Matiere *m_plan = new MatHom(PropOpt(0.2f, 0.0f, 0.8f, 0.2f, 0.4f, 0.0f, 0.0f, 0.0f, SpectrePuiss(0.5, 0.35, 0.35)));
	Objet obj1(&sph, R2, mat_rouge, RTexSph);
	Objet obj2(&sph2, R, m_sph2, R);
	Objet obj3(&plan, RPlan, m_plan, RPlan);
	LampeIso lpIso(RLampe2, SpectrePuiss(0.9f, 0.2f, 0.2f));
	LampeIso lpIso2(RLampe, SpectrePuiss(0.2f, 0.9f, 0.2f));
	LampeIso lpIso3(RLampe3, SpectrePuiss(0.2f, 0.2f, 0.9f));

	QuantifSepia Quant;
	//QuantifNB Quant;
	//QuantifClassic Quant;
	Film<RGB> F(800, 800, &Quant);

	F.init(RGB(0, 0, 0));
	Scene scene(&lpIso, obj3, NULL, &F); 
	scene.addObjet(obj1);
	scene.addObjet(obj2);
	scene.addLampe(&lpIso2); 
	//scene.addLampe(&lpIso3); 

	scene.Rendu();

	saveppm(F, "new_version5");

	return 0;
}

int main_Phong()
{
	Sphere sph(5.1f), sph2(1.7f);
	Plan plan(vR3(0.0f, -1.0f, 0.0f), 4.4f);
	Repere R(pR3(0.0f, -0.5f, 4.0f)), RPlan(pR3(0., 1., 0.)), R2(pR3(3.5f, -0.5f, 2.0f)), RLampe(pR3(-4.0f, 2.0f, 2.0f)), RLampe2(pR3(4.0f, 2.0f, 4.0f)), RLampe3(pR3(0., -6.0f, 4.0f));
	Matiere *mat_rouge = new MatHom(PropOpt(0.4, 0.6, 0.6, 0.2, 0.4, 0.0, 0.0, 0.0, SpectrePuiss(0.8, 0.8, 0.8)));
	Matiere *m_plan = new MatHom(PropOpt(0.2, 0.0, 0.8, 0.2, 0.4, 0.0, 0.0, 4.0, SpectrePuiss(0.5, 0.5, 0.5)));
	Objet obj1(&sph, R, mat_rouge, R);

	LampeIso lpIso(RLampe2, SpectrePuiss(0.1f, 0.9f, 0.1f));
	LampeIso lpIso2(RLampe, SpectrePuiss(0.1f, 0.1f, 0.9f));
	LampeIso lpIso3(RLampe3, SpectrePuiss(0.9f, 0.1f, 0.1f));

	QuantifClassic Quant;
	Film<RGB> F(800, 800, &Quant);

	F.init(RGB(0, 0, 0));
	Scene scene(&lpIso, obj1, NULL, &F); 
	scene.addLampe(&lpIso2); 
	scene.addLampe(&lpIso3); 

	scene.Rendu();

	saveppm(F, "phong14");

	return 0;
}

int main_Whitted()
{
	Sphere sph(5.1f), sph2(3.7f);
	Plan plan(vR3(0.0f, -1.0f, 0.0f), 4.4f);
	Repere R(pR3(-1.0f, -0.5f, 5.0f)), RPlan(pR3(0., 1., 0.)), R2(pR3(1.0f, -0.5f, 2.0f)), RLampe(pR3(0.0f, 2.0f, 2.0f)), RLampe2(pR3(0.0f, 2.0f, 4.0f)), RLampe3(pR3(0., -6.0f, 4.0f));
	Matiere *mat_rouge = new MatHom(PropOpt(0.1, 0.6, 0.6, 0.2, 0.4, 0.0, 0.0, 0.0, SpectrePuiss(0.8, 0.8, 0.8)));
	Matiere *mat_bleu = new MatHom(PropOpt(0.1, 0.6, 0.6, 0.2, 0.4, 0.0, 0.0, 0.0, SpectrePuiss(0.8, 0.2, 0.8)));
	Matiere *m_plan = new MatHom(PropOpt(0.2, 0.0, 0.8, 0.2, 0.4, 0.0, 0.0, 4.0, SpectrePuiss(0.5, 0.5, 0.5)));
	Objet obj1(&sph, R, mat_rouge, R);
	Objet obj2(&sph2, R2, mat_bleu, R2);

	LampeIso lpIso(RLampe2, SpectrePuiss(0.9f, 0.9f, 0.9f));
	LampeIso lpIso2(RLampe, SpectrePuiss(0.2f, 0.9f, 0.2f));
	LampeIso lpIso3(RLampe3, SpectrePuiss(0.9f, 0.1f, 0.1f));

	QuantifClassic Quant;
	Film<RGB> F(800, 800, &Quant);

	F.init(RGB(0, 0, 0));
	Scene scene(&lpIso, obj1, NULL, &F); 
	scene.addObjet(obj2);
	//scene.addLampe(&lpIso2); 
	//scene.addLampe(&lpIso3); 

	scene.Rendu();

	saveppm(F, "reflexion2");

	return 0;
}


int main_sceneII()
{
	Sphere sph(3.5f), sph2(1.55f);
	Plan plan(vR3(0.0f, -1.0f, 0.0f), 4.4f);
	Repere RTexSph(vR3(1., 0., 0.), vR3(0., 1., 0.), vR3(0., 1., 0.)^vR3(1., 0., 0.));
	Repere R(pR3(1, -2.8f, 3.5f)), R2(pR3(-5.5f, -0.5f, 7.5f)), RPlan(pR3(0., 2., 0.)), RLampe(pR3( 0.0f, 5.0f, 5.0f)), RLampe2(pR3(2.0f, 3.0f, 5.0f));
	Matiere *mat_rouge = new MatHom(PropOpt(0.2, 0.5, 0.9, 0.2, 0.4, 0.0, 0.2, 1.8, SpectrePuiss(0.8f, 0.8f, 0.8f)));
	Matiere *m_sph2 = new MatHom(PropOpt(0.2, 0.2, 0.3, 0.2, 0.4, 0.0, 0.2, 1.8, SpectrePuiss(0.8f, 0.8f, 0.8f)));
	Matiere *m_plan = new MatHom(PropOpt(0.2, 0.0, 0.6, 0.2, 0.4, 0.0, 0.6, 4.0, SpectrePuiss(0.5f, 0.5f, 0.5f)));
	Objet obj1(&sph, R, mat_rouge, RTexSph);
	obj1.loadTexture("./alpright.tga");
	Objet obj2(&sph2, R2, m_sph2, R2);
	Objet obj3(&plan, RPlan, m_plan, RPlan);
	obj3.loadTexture("./wood.tga");
	LampeIso lpIso(RLampe, SpectrePuiss(0.8f, 0.8f, 0.8f));
	LampeIso lpIso2(RLampe2, SpectrePuiss(0.5f, 0.1f, 0.1f));
	//QuantifNB Quant;
	QuantifClassic Quant;
	Film<RGB> F(800, 800, &Quant);

	F.init(RGB(0, 0, 0));
	Scene scene(&lpIso, obj3, NULL, &F); 
	scene.addObjet(obj1);
	scene.addObjet(obj2);
	//scene.addLampe(&lpIso2); 

	scene.Rendu();

	saveppm(F, "new_version6");

	return 0;
}


#endif
