#ifndef FORME_H_
#define FORME_H_

#include <iostream>
#include "algebre.h"
#include "rayon.h"
#include "matiere.h"
#include "texture.h"

using namespace std;

////////////////////////// Objets //////////////////////////////////////////////

class Forme
{
	protected:
	public :
		virtual float inter  (const Rayon&) const =0;
        virtual vR3   normale(const pR3 &p) const=0;

		// Rcupration des coordonnes de texture (cf: rapport pour explications)
		virtual void  texCoords(const pR3& pos, const Repere& RTex, float&, float&) const = 0;
};


class Sphere: public Forme
{
	public:
			float r;						// Rayon de la sphre

		Sphere(float ray=1.0f) : r(ray) {}

		float inter(const Rayon& R) const
		{
			float b = -(R.O%R.D);
			float det = (b * b) - (R.O%R.O) + (r*r);
			if (det > 0.0f)
			{
				det = sqrtf(det);
				float i1 = b - det;
				float i2 = b + det;

				if (i2 > 0.0f)
					if (i1 < 0.0f) 
						return -i2;	// Detection de l'interieur de la sphere (loi de Beer ==> Refraction)
					else
						return i1;  // Intersection  l'exterieur de la sphere 
			}
			return 0.0f;
		}

		vR3 normale(const pR3 &p) const
		{
			return Unitaire(p);
		}

		void  texCoords(const pR3& pos, const Repere& RTex, float& u, float& v) const
		{
			vR3 vp(Unitaire(pos * r));

			float phi(acosf(-(vp%RTex.Y)));

			v = phi * (1.0f / 0.8f) * (1.0f / PI);
			float theta((acosf(RTex.X%vp) / sinf(phi)) * (2.0f / PI));
			if((RTex.Z%vp ) >= 0) u = (1.0f - theta) * (1.0f / 0.8f);
			else u = theta * (1.0f/0.8f);
		}
};

class CompPlan
{
	friend class Plan;

	protected:
		vR3 N;
		float D;

	public:
		CompPlan(const vR3& _norm=vR3(0., 0., 0.), const float& _f=0.0f) : N(_norm), D(_f) {}
};


// Gestion de plan "infini"
// Comprend: une normale, t un coefficient
// (Object CompPlan: Normale + coeff.)

class Plan : public Forme
{
	protected:
		CompPlan plan;

	public:
		Plan(const vR3&  _norm=vR3(), const float&  _f=0.0f);
		float inter(const Rayon& R) const;
		vR3   normale(const pR3& p) const;
		void  texCoords(const pR3& pos, const Repere& RTex, float& u, float& v) const;
};

Plan::Plan(const vR3& V, const float& F) : plan(V, F)
{}

float Plan::inter(const Rayon& Ray) const
{
	float f = (plan.N % Ray.D);

	if(f != 0.0f)
	{
		float t = -( (plan.N % Ray.O) + plan.D ) / f;

		if(t > 0.0f)
			return t;
	}
	return 0.0f; 
}

vR3 Plan::normale(const pR3& P) const
{
	return plan.N;
}

void  Plan::texCoords(const pR3& pos, const Repere& RTex, float& u, float& v) const
{
		static vR3 axex = vR3(plan.N.y, plan.N.z, -plan.N.x);
		static vR3 axey = vR3(axex^plan.N);
		u = (Unitaire(pos)%axex) * 0.35f;
		v = (Unitaire(pos)%Unitaire(axey)) * 0.35f;
}

#endif // FORME_H_
