#ifndef COULEUR_H_
#define COULEUR_H_

////////////////////////// Proprietes optiques /////////////////////////////////
class SpectrePuiss;

class RGB   // pixels rsultats (aprs quantification par les films couleur)
  { public : unsigned char r,g,b;

   RGB(unsigned char _r=0, unsigned char _g=0, unsigned char _b=0) : r(_r),g(_g),b(_b) {}
    
   RGB (const SpectrePuiss & S, float M=1.0);
  };

class SpectrePuiss // puissances "colores" de transmission ou d'absorption en watts
  { public : float         r,g,b;

  SpectrePuiss(float R=0, float G=0, float B=0) : r(R),g(G),b(B) {}

  SpectrePuiss(const RGB &col, float c=1.0) : r(c*col.r/255.0),g(c*col.g/255.0),b(c*col.b/255.0) {}

  SpectrePuiss operator + (const SpectrePuiss &S) const
   {
		return SpectrePuiss(r+S.r,g+S.g,b+S.b);
   }

  SpectrePuiss operator - (const SpectrePuiss &S) const
   { return SpectrePuiss(r-S.r,g-S.g,b-S.b); }

  SpectrePuiss operator * (const SpectrePuiss &S) const
   { return SpectrePuiss(r*S.r,g*S.g,b*S.b); }

  SpectrePuiss operator * (float a) const
   { return SpectrePuiss(a*r,a*g,a*b); }

  SpectrePuiss operator / (float a) const
   { return SpectrePuiss(r/a,g/a,b/a); }
  };

inline SpectrePuiss operator * (float a, const SpectrePuiss &S) { return S*a; }

inline RGB::RGB (const SpectrePuiss & S, float M) : r((unsigned char)(S.r/M*255)),
                                                    g((unsigned char)(S.g/M*255)),
                                                    b((unsigned char)(S.b/M*255)) {}



#endif // COULEUR_H_
