#ifndef CAMERA_H_
#define CAMERA_H_

#include "quantif.h"
#include "algebre.h"
#include "couleur.h"
#include "repere.h"
#include "rayon.h"

class Camera
{
	public :
		float L, H;		// L: largeur du fond de chambre, H: Hauteur

		Camera(const float& _L, const float& _H);			
        virtual Rayon DemiDroite(const pR2&) const = 0;		// Rayon du point d'origine de la camra vers le point vis
		virtual pR2 Projection(const pR3&) const = 0;		// Projection d'un point de la scene 
};

Camera::Camera(const float& _L, const float& _H) : L(_L), H(_H)
{}

class PinHole : public Camera
{
	public:
		float focale;
		Repere rPropre;

		PinHole(const float& _L, const float& _H, const float& _foc, const Repere& R);

		Rayon DemiDroite(const pR2&) const;
		pR2 Projection(const pR3&) const;
};

PinHole::PinHole(const float& _L, const float& _H, const float& _foc, const Repere& R)
	: Camera(_L, _H), focale(_foc), rPropre(R)
{}

pR2 PinHole::Projection(const pR3& P) const
{
	return pR2(0.5f+(focale/L)*(P.x/P.z), 0.5f+(focale/H)*(P.y/P.z));
}

Rayon PinHole::DemiDroite(const pR2& Pr) const
{
	return Rayon(rPropre.O, vR3(L * (Pr.x-0.5f), H * (Pr.y-0.5f), focale));
}

template <class Pix>
class Film
{
	public : short nc,nl;                   // dimensions image nb col, nb lig
                         Pix  *image;                   // buffer des pixels
                         Quantif<SpectrePuiss,Pix> *Q;  // Quantifieur

                Film (short Nc, short Nl, Quantif<SpectrePuiss,Pix> *q)
                 : nc(Nc), nl(Nl),image(new Pix [Nc*Nl]), Q(q)
                 {}

               ~Film () { delete[] image; }

			   void init(const Pix& value)
			   {
				    Pix* r = image;
					for(int i(nc*nl);i--;r++)
						*r = value;
			   }
               
               pR3  GetPosRelPix(int i, int j, float L, float H) const { return pR3 (L*i/nc-L/2, H*j/nl-H/2, 0); }
};


#endif // CAMERA_H_
