#ifndef _REGION_H_
#define _REGION_H_

#include <list>

#include "define.h"

using namespace std;

class region
{
	friend class Stat;

	protected:
		int nbpix;

	public:
		region();

		void	addPixel();
		int		getNbPixel() const;
		int		getRayon() const;
};

class Stat
{
	protected:
		int moy;
		region maxReg;
		region minReg;
		

	public:
		list<region> lReg;

		Stat();
		Stat(const Stat&);

		Stat& operator =(const Stat&);

		void reset();
		void addRegion(const region&);
		int getNbRegion() const;
		int moyenne() const;
		int getBigger() const;
		int getSmaller() const;
		int getRayMax() const;
		int getRayMin() const;

		// User friendly method(s)

		void affiche() const;
};

#endif // _REGION_H_
