#include <cmath>
#include "region.h"
#include <iostream>
using namespace std;

///
//	DEF class region
///


region::region() : nbpix(0)
{}

void region::addPixel()
{
	++nbpix;
}

int region::getNbPixel() const
{
	return nbpix;
}

int region::getRayon() const
{
	if(nbpix < 4)
		return 1;
	else
		return (int)(sqrt(((double)nbpix) / M_PI));
}


//////////////////////////////////////////////////////////

Stat::Stat() :  moy(0), maxReg(), minReg(), lReg()
{}

Stat::Stat(const Stat& _s) : maxReg(_s.maxReg), minReg(_s.minReg), moy(_s.moy), lReg(_s.lReg)
{}

Stat& Stat::operator =(const Stat& _s)
{
	maxReg = _s.maxReg;
	minReg = _s.minReg;
	moy    = _s.moy;
	lReg   = _s.lReg;

	return (*this);
}

void Stat::reset() 
{
	maxReg = minReg = region();
	moy = 0;
	lReg.clear();
}

void Stat::addRegion(const region& _r)
{
	int n(_r.getNbPixel());

	moy += n;

	if(n > maxReg.getNbPixel())
		maxReg = _r;
	if(n < minReg.getNbPixel() || !(lReg.size()))
			minReg = _r;

	lReg.push_back(_r);
}

int Stat::getNbRegion() const
{
	return lReg.size();
}

int Stat::moyenne() const
{
	if(lReg.size())
		return moy / lReg.size();
	else
		return 0;
}

int Stat::getBigger() const
{
	return maxReg.getNbPixel();
}

int Stat::getSmaller() const
{
	return minReg.getNbPixel();
}

int Stat::getRayMax() const
{
	return maxReg.getRayon();
}

int Stat::getRayMin() const
{
	return minReg.getRayon();
}

void Stat::affiche() const
{
	cout << "Nb de regions totales: " << lReg.size() << endl;
	cout << "Plus grosse region traitee: " << getBigger() << endl;
	cout << "Diametre de la plus grosse region (en pixels): " << maxReg.getRayon() << endl;
	cout << "Plus petite region traitee: " << getSmaller() << endl;
	cout << "Diametre de la plus petite region (en pixels): " << minReg.getRayon() << endl;
	cout << "Moyenne des grains et pierres traites: " << moyenne() << endl;
}
