
#include "original.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qimage.h>
#include <qpixmap.h>


void MyDialog::setImage(const QPixmap& npix, int pos)
{
    if(pos >= 0 && pos < 4)
    {
	switch(pos)
	{
	case 0: pix21->setPixmap(npix);
		break;
	case 1: pix22->setPixmap(npix);
		break;
	case 2: pix23->setPixmap(npix);
		break;
	case 3: pix24->setPixmap(npix);
		break;
	default: break;
	}
    }
}

QPixmap* MyDialog::getPixmap(int pos) const
{
    if(pos >= 0 && pos < 4)
    {
	switch(pos)
	{
	case 0: return pix21->pixmap();
		break;
	case 1: return pix22->pixmap();
		break;
	case 2: return pix23->pixmap();
		break;
	case 3: return pix24->pixmap();
		break;
	default: break;
	}
    }
}

void MyDialog::init()
{
    QImage img_tmp;
    img_tmp.load(QString("./images/fleche.png"), QImage::imageFormat("./images/fleche.png"));
    fleche1->setPixmap(img_tmp);
    fleche2->setPixmap(img_tmp);
}



/*
 *  Constructs a MyDialog as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
MyDialog::MyDialog( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "MyDialog" );
    setSizeGripEnabled( TRUE );

    QWidget* privateLayoutWidget = new QWidget( this, "Layout1" );
    privateLayoutWidget->setGeometry( QRect( 20, 570, 430, 33 ) );
    Layout1 = new QHBoxLayout( privateLayoutWidget, 0, 6, "Layout1"); 


    pix21 = new QLabel( this, "pix21" );
    pix21->setGeometry( QRect( 20, 20, 286, 173 ) );

    pix23 = new QLabel( this, "pix23" );
    pix23->setGeometry( QRect( 320, 20, 286, 173 ) );

    pix24 = new QLabel( this, "pix24" );
    pix24->setGeometry( QRect( 320, 220, 286, 173 ) );

    pix22 = new QLabel( this, "pix22" );
    pix22->setGeometry( QRect( 20, 220, 286, 173 ) );

    fleche1 = new QLabel( this, "fleche1" );
    fleche1->setGeometry( QRect( 310, 86, 22, 22 ) );

    fleche2 = new QLabel( this, "fleche2" );
    fleche2->setGeometry( QRect( 310, 320, 22, 22 ) );
    languageChange();
    //resize( QSize(958, 614).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
    init();
   
}

/*
 *  Destroys the object and frees any allocated resources
 */
MyDialog::~MyDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void MyDialog::languageChange()
{
    setCaption( tr( "MyDialog" ) );
    pix21->setText( QString::null );
    pix23->setText( QString::null );
    pix24->setText( QString::null );
    pix22->setText( QString::null );
    fleche1->setText( QString::null );
    fleche2->setText( QString::null );
}


