
#include "main_win.h"

#include <qapplication.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qstatusbar.h>
#include <qdir.h>
#include <qfiledialog.h>
#include <qmsgbox.h>
#include <qsemaphore.h>
#include <fstream>
#include <iostream>
using namespace std;

#include "fonction.h"
#include "image.h"
#include "region.h"


/*
void Form1::fileNew()
{
QString fn = QFileDialog::getOpenFileName( QString::null, "Images (*.ppm)", this);
    
	
    QFile f( fileName );
    if ( !f.open( IO_ReadOnly ) )
        return;

    QTextStream ts( &f );
    e->setText( ts.read() );
    e->setModified( FALSE );
    setCaption( fileName );
    statusBar()->message( "Loaded document " + fileName, 2000 );
    
}
*/



void Form1::fileOpen()
{
    QString fn = QFileDialog::getOpenFileName( QString::null, "Project file (*.prj)", (QWidget*)this,"Open an picture ( PPM )");
    trait=false;
    if ( !fn.isEmpty() )
    {
		fn.remove('\n');
	
	
	
		QLabel* pix_tab[2] = { pix1, pix2 };
		QPixmap pmp;
		QImage img;
		QFile flit(fn);
		flit.open(IO_ReadOnly | IO_Translate);

		ofstream flot("./res/cur_proj",ios::out);
		//flit.open(IO_WriteOnly | IO_Translate);
	
		int i(0);	
		while(!flit.atEnd() && i < 2)
		{
			flit.readLine(*(tot_img+i), 256);
			(tot_img+i)->remove('\n');
			flot<<*(tot_img+i)<<endl;
			bool ret=img.load(*(tot_img+i), QImage::imageFormat(tot_img[i]));
	
			if(!ret)
			{
				statusBar()->message( "Error when loading "+ *(tot_img+i), 5000 );
				return;
			}	
			img = img.smoothScale(pix_tab[i]->width(), pix_tab[i]->height(), QImage::ScaleMax);
			pmp.convertFromImage(img);
			pix_tab[i]->setPixmap(pmp);
			++i;
		}
		flit.close();
		flot.close();
		statusBar()->message( fn +" loaded ", 5000 );

		
		t1->start();
		t2->start();

    }
    else
        statusBar()->message( "Loading aborted", 5000 );
}


void Form1::fileSave()
{

}


void Form1::fileSaveAs()
{

}


void Form1::filePrint()
{
	if (!trait)
		if ( QMessageBox::warning(this,"Impression","Lancer le traitement du projet ?", "Lancer","Abandonner",0,0,1) == 0 )
			traitementProcederAction_activated();
		else
			return;
		
	QPrinter *printer=new QPrinter(QPrinter::PrinterResolution);
		
	printer->setFullPage( TRUE );
	printer->setOrientation( QPrinter::Landscape );
	printer->setColorMode( QPrinter::Color );
        if ( printer->setup(this) )
	{               // printer dialog
            statusBar()->message( "Printing..." );
            QPainter p;
            if( !p.begin( printer ) )
	    {               // paint on printer
                statusBar()->message( "Printing aborted", 2000 );
                return;
            }

            QPaintDeviceMetrics metrics( p.device() );
            int dpiy = metrics.logicalDpiY();
            int margin = (int) ( (2/2.54)*dpiy ); // 2 cm margins
	                         	   
 			p.drawPixmap(10,10,*(dial->sousf1->getPixmap(0)) );
            p.translate( 0 , dial->sousf1->getPixmap(0)->height()+10 );

            p.drawPixmap(10,10,*(dial->sousf1->getPixmap(1)) );
            p.translate( dial->sousf1->getPixmap(0)->width()+10 , - ( dial->sousf1->getPixmap(0)->height()+10) );

            p.drawPixmap(10,10,*(dial->sousf1->getPixmap(2)) );
            p.translate( 0 , dial->sousf1->getPixmap(2)->height()+10 );

            p.drawPixmap(10,10,*(dial->sousf1->getPixmap(3)) );
	    
            p.translate(dial->sousf1->getPixmap(2)->width()+15, -dial->sousf1->getPixmap(2)->height() );
            p.drawText(0,0,"Detection par chapeau haut de forme."); 	
            p.end();
	    
	    statusBar()->message( "Printing completed", 2000 );
        }
	else
	{	statusBar()->message( "Printing aborted", 2000 );	}
	
delete printer;
}


void Form1::fileExit()
{
	exit(0);
}


void Form1::helpIndex()
{

}


void Form1::helpContents()
{



}


void Form1::helpAbout()
{

    
}

void Form1::init()
{
	
	statText->setReadOnly(true);
	QApplication::setOverrideCursor(QCursor(Qt::WaitCursor)); 
	int i(0);	
	QFile flit("./JB_project/proj1.prj");
	flit.open(IO_ReadOnly | IO_Translate);
	QLabel* pix_tab[2] = { pix1, pix2 };
	QPixmap pmp;
	QImage img;
	
	ofstream flot("./res/cur_proj",ios::out);
	while(!flit.atEnd() && i < 2)
	{
		flit.readLine(*(tot_img+i), 256);
		(tot_img+i)->remove('\n');
		flot<<*(tot_img+i)<<endl;
		
		bool ret=img.load(*(tot_img+i), QImage::imageFormat(tot_img[i]));
	
		if(!ret)
			statusBar()->message( "Error when loading "+ *(tot_img+i), 2000 );

				
		img = img.smoothScale(pix_tab[i]->width(), pix_tab[i]->height(), QImage::ScaleMax);
		pmp.convertFromImage(img);
		pix_tab[i]->setPixmap(pmp);
		++i;
	}
	flit.close();
	flot.close();

	t1->start();
	t2->start();
	
	dial=new dialog(this,tr("Rsultat"));
	QApplication::restoreOverrideCursor();

}

void Form1::traitementProcederAction_activated()
{
	
	if(trait)
	{
		QApplication::setOverrideCursor(QCursor(Qt::WaitCursor)); 
		dial->show();
		QApplication::restoreOverrideCursor();
		return;
	}
	else
	{
		trait=true;
		QApplication::setOverrideCursor(QCursor(Qt::WaitCursor)); 
				
		int evo_pop1, evo_big1, evo_moy1,ray1, pourc_pop, pourc_big, pourc_moy;
		int evo_pop2, evo_big2, evo_moy2,ray2;
		Image<UCHAR> imgPop(256, 256);
		ImgCouleur img1;

	(*sem)++; // attente des threads de calculs

		ifstream flin("./res/rapport1",ios::in);
		flin>>evo_pop1>>evo_big1>>ray1>>evo_moy1;
		flin.close();
		QFile::remove("./res/rapport1");

		statText->setBold(true);
		statText->append("Avant erosion par la pluie: ");
		statText->setBold(false);
		statText->append(QString("Nombre total de grains dtcts: ") + QString(QString::number(evo_pop1)));
		statText->append(QString("Plus gros volume de grains dtct (en pixel): ") + QString(QString::number(evo_big1)));
		statText->append(QString("Diamtre de la plus grosse region (en pixels): ") + QString(QString::number(ray1)));
		statText->append(QString("Moyenne des volumes des rgions (en pixels): ") + QString(QString::number(evo_moy1)));
		statText->append("\n---------------------------------\n");
		

		imgPop.load("./res/imgPop1.ppm");
		dial->hPop->setPixmap(MyImage2QPixmap( imgPop ), 0);
		QFile::remove("./res/imgPop1.ppm");
		
		imgPop.load("./res/sousf0.ppm");
		dial->sousf1->setImage(MyImage2QPixmap(&imgPop),0 );
		QFile::remove("./res/sousf0.ppm");


		img1.loadPPM("./res/sousf2.ppm");
		dial->sousf1->setImage(MyImage2QPixmap(&img1), 2);
		QFile::remove("./res/sousf2.ppm");
	
	(*sem2)++;
			
		flin.open("./res/rapport2",ios::in);
		flin>>evo_pop2>>evo_big2>>ray2>>evo_moy2;
		flin.close();
		QFile::remove("./res/rapport2");

		statText->setBold(true);
		statText->append("Aprs erosion par la pluie: ");
		statText->setBold(false);
		statText->append(QString("Nombre total de grains dtects: ") + QString(QString::number(evo_pop2)));
		statText->append(QString("Plus gros volume de grains dtct (en pixel): ") + QString(QString::number(evo_big2)));
		statText->append(QString("Diamtre de la plus grosse region (en pixels): ") + QString(QString::number(ray2)));
		statText->append(QString("Moyenne des volumes des rgions (en pixels): ") + QString(QString::number(evo_moy2)));

		imgPop.load("./res/imgPop2.ppm");
		dial->hPop->setPixmap(MyImage2QPixmap( imgPop), 1);
		QFile::remove("./res/imgPop2.ppm");

		pourc_pop = (int)((((double)evo_pop2) / ((double)evo_pop1)) * 100);
		pourc_big = (int)((((double)evo_big2) / ((double)evo_big1)) * 100);
		pourc_moy = (int)((((double)evo_moy2) / ((double)evo_moy1)) * 100);

		dial->hPop->getTxtZone()->setBold(true);
		dial->hPop->getTxtZone()->append(QString("Constats sur volution des populations de grains:"));
		dial->hPop->getTxtZone()->setBold(false);
		dial->hPop->getTxtZone()->append(QString("Evolution de la population de grains: ") + QString::number(pourc_pop));
		dial->hPop->getTxtZone()->append(QString("Evolution du plus gros grain: ") + QString::number(pourc_big));
		dial->hPop->getTxtZone()->append(QString("Evolution de la moyenne du volume (en pixels) des grains: ") + QString::number(pourc_moy));

		imgPop.load("./res/sousf1.ppm");
		dial->sousf1->setImage(MyImage2QPixmap(&imgPop), 1);
		QFile::remove("./res/sousf1.ppm");
		
		img1.loadPPM("./res/sousf3.ppm");
		dial->sousf1->setImage(MyImage2QPixmap(&img1), 3);
		QFile::remove("./res/sousf3.ppm");

	(*sem)--,(*sem2)--;

		dial->show();

		QApplication::restoreOverrideCursor();
	}
}






/*
 *  Constructs a Form1 as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 */
Form1::Form1( QWidget* parent, const char* name, WFlags fl )
    : QMainWindow( parent, name, fl )
{
    
    trait=false;
    (void)statusBar();
    if ( !name )
	setName( "Form1" );
    setCentralWidget( new QWidget( this, "qt_central_widget" ) );

    pix2 = new QLabel( centralWidget(), "pix2" );
    pix2->setGeometry( QRect( 20, 220, 491, 190 ) );
    pix2->setScaledContents( TRUE );

    stats = new QGroupBox( centralWidget(), "stats" );
    stats->setGeometry( QRect( 20, 430, 500, 121 ) );

    statText = new QTextEdit( stats, "statText" );
    statText->setGeometry( QRect( 10, 21, 481, 91 ) );
    statText->setPaletteBackgroundColor( QColor( 236, 233, 215 ) );
    QPalette pal;
    QColorGroup cg;
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 236, 233, 216) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 241, 239, 226) );
    cg.setColor( QColorGroup::Dark, QColor( 172, 168, 153) );
    cg.setColor( QColorGroup::Mid, QColor( 157, 155, 143) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, QColor( 236, 233, 215) );
    cg.setColor( QColorGroup::Background, QColor( 236, 233, 216) );
    cg.setColor( QColorGroup::Shadow, QColor( 113, 111, 100) );
    cg.setColor( QColorGroup::Highlight, QColor( 49, 106, 197) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 255) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 255, 0, 255) );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 236, 233, 216) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 241, 239, 226) );
    cg.setColor( QColorGroup::Dark, QColor( 172, 168, 153) );
    cg.setColor( QColorGroup::Mid, QColor( 157, 155, 143) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, QColor( 236, 233, 215) );
    cg.setColor( QColorGroup::Background, QColor( 236, 233, 216) );
    cg.setColor( QColorGroup::Shadow, QColor( 113, 111, 100) );
    cg.setColor( QColorGroup::Highlight, QColor( 236, 233, 216) );
    cg.setColor( QColorGroup::HighlightedText, black );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 255) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 255, 0, 255) );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 118, 116, 108) );
    cg.setColor( QColorGroup::Button, QColor( 236, 233, 216) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 245, 244, 235) );
    cg.setColor( QColorGroup::Dark, QColor( 172, 168, 153) );
    cg.setColor( QColorGroup::Mid, QColor( 157, 155, 143) );
    cg.setColor( QColorGroup::Text, QColor( 118, 116, 108) );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, QColor( 118, 116, 108) );
    cg.setColor( QColorGroup::Base, QColor( 236, 233, 215) );
    cg.setColor( QColorGroup::Background, QColor( 236, 233, 216) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 49, 106, 197) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 255) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 255, 0, 255) );
    pal.setDisabled( cg );
    statText->setPalette( pal );
    statText->setFrameShape( QTextEdit::NoFrame );
    statText->setFrameShadow( QTextEdit::Plain );

    pix1 = new QLabel( centralWidget(), "pix1" );
    pix1->setGeometry( QRect( 20, 21, 491, 190 ) );
    pix1->setScaledContents( TRUE );

    // actions
 //   fileNewAction = new QAction( this, "fileNewAction" );
  //  fileNewAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "filenew" ) ) );
    
    fileOpenAction = new QAction( this, "fileOpenAction" );
    fileOpenAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "fileopen" ) ) );
    
    fileSaveAction = new QAction( this, "fileSaveAction" );
    fileSaveAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "filesave" ) ) );
    fileSaveAsAction = new QAction( this, "fileSaveAsAction" );
    fileSaveAsAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "filesave" ) ) );
    filePrintAction = new QAction( this, "filePrintAction" );
    filePrintAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "print" ) ) );
    fileExitAction = new QAction( this, "fileExitAction" );
    
    frenchAction=new QAction(this,"frenchAction");
    englishAction=new QAction(this,"englishAction");
    
    helpContentsAction = new QAction( this, "helpContentsAction" );
    helpIndexAction = new QAction( this, "helpIndexAction" );
    helpAboutAction = new QAction( this, "helpAboutAction" );
    
    traitementProcederAction = new QAction( this, "traitementProcederAction" );
    traitementIntermdiairesAction = new QAction( this, "traitementIntermdiairesAction" );

    // menubar
    MenuBar = new QMenuBar( this, "MenuBar" );


    Fichier = new QPopupMenu( this );
    fileOpenAction->addTo( Fichier );
    fileSaveAction->addTo( Fichier );
    fileSaveAsAction->addTo( Fichier );
    Fichier->insertSeparator();
    filePrintAction->addTo( Fichier );
    Fichier->insertSeparator();
    fileExitAction->addTo( Fichier );
    MenuBar->insertItem( QString(""), Fichier, 1 );

    Traitement = new QPopupMenu( this );
    traitementProcederAction->addTo( Traitement );
    traitementIntermdiairesAction->addTo( Traitement );
    MenuBar->insertItem( QString(""), Traitement, 2 );

    Aide = new QPopupMenu( this );
    helpContentsAction->addTo( Aide );
    helpIndexAction->addTo( Aide );
    Aide->insertSeparator();
    helpAboutAction->addTo( Aide );
    MenuBar->insertItem( QString(""), Aide, 3 );

    Langue=new QPopupMenu( this );
    frenchAction->addTo(Langue);
    englishAction->addTo(Langue);
    MenuBar->insertItem( QString(""), Langue, 4 );

    french();
    resize( QSize(532, 600).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    //connect( fileNewAction, SIGNAL( activated() ), this, SLOT( fileNew() ) );
    connect( fileOpenAction, SIGNAL( activated() ), this, SLOT( fileOpen() ) );
    connect( fileSaveAction, SIGNAL( activated() ), this, SLOT( fileSave() ) );
    connect( fileSaveAsAction, SIGNAL( activated() ), this, SLOT( fileSaveAs() ) );
    connect( filePrintAction, SIGNAL( activated() ), this, SLOT( filePrint() ) );
    connect( fileExitAction, SIGNAL( activated() ), this, SLOT( fileExit() ) );
    connect( frenchAction, SIGNAL( activated() ), this, SLOT( french() ) );
    connect( englishAction, SIGNAL( activated() ), this, SLOT( english() ) );
    connect( helpIndexAction, SIGNAL( activated() ), this, SLOT( helpIndex() ) );
    connect( helpContentsAction, SIGNAL( activated() ), this, SLOT( helpContents() ) );
    connect( helpAboutAction, SIGNAL( activated() ), this, SLOT( helpAbout() ) );
    connect( traitementProcederAction, SIGNAL( activated() ), this, SLOT( traitementProcederAction_activated() ) );

	sem=new QSemaphore(1);
	sem2=new QSemaphore(1);
	cout<<"avial 0="<<sem->available()<<endl;
	t1=new ThreadImg1(this);
	t2=new ThreadImg2(this);
    init();
}

/*
 *  Destroys the object and frees any allocated resources
 */
Form1::~Form1()
{
    // no need to delete child widgets, Qt does it all for us
	delete sem, sem2;
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void Form1::languageChange()
{
    french();
}



void Form1::french()
{
	setCaption( tr( "Projet de traitement d'image: chapeau haut de forme" ) );
    stats->setTitle( tr( "Statistiques - Evolution" ) );
   // fileNewAction->setText( tr( "Nouveau" ) );
    //fileNewAction->setMenuText( tr( "&Nouveau" ) );
    //fileNewAction->setAccel( tr( "Ctrl+N" ) );
    
    fileOpenAction->setText( tr( "Ouvrir" ) );
    fileOpenAction->setMenuText( tr( "&Ouvrir..." ) );
    fileOpenAction->setAccel( tr( "Ctrl+O" ) );

    fileSaveAction->setText( tr( "Enregistrer" ) );
    fileSaveAction->setMenuText( tr( "Enregi&strer" ) );
    fileSaveAction->setAccel( tr( "Ctrl+S" ) );
    
    fileSaveAsAction->setText( tr( "Enregistrer sous..." ) );
    fileSaveAsAction->setMenuText( tr( "Enregistrer sous..." ) );
    fileSaveAsAction->setAccel( QString::null );
    
    filePrintAction->setText( tr( "Imprimer" ) );
    filePrintAction->setMenuText( tr( "Im&primer..." ) );
    filePrintAction->setAccel( tr( "Ctrl+P" ) );
    
    
    fileExitAction->setText( tr( "Quitter" ) );
    fileExitAction->setMenuText( tr( "Quitter" ) );
    fileExitAction->setAccel( tr( "Ctrl+Q" ) );
    
    helpContentsAction->setText( tr( "Contenu" ) );
    helpContentsAction->setMenuText( tr( "&Contenu..." ) );
    helpContentsAction->setAccel( tr( "Ctrl+C" ) );
    
    helpIndexAction->setText( tr( "Index" ) );
    helpIndexAction->setMenuText( tr( "&Index..." ) );
    helpIndexAction->setAccel( tr( "Ctrl+I" ) );
    
    helpAboutAction->setText( tr( "A Propos" ) );
    helpAboutAction->setMenuText( tr( "&A Propos" ) );
    helpAboutAction->setAccel( tr( "Ctrl+A" ) );
    
    traitementProcederAction->setText( tr( "Proceder" ) );
    traitementProcederAction->setMenuText( tr( "P&roceder" ) );
    traitementProcederAction->setAccel( tr( "Ctrl+R" ) );
        
    traitementIntermdiairesAction->setText( tr("Intermedaire") );
    traitementIntermdiairesAction->setMenuText(tr("Intermedaire") );
    
    frenchAction->setText( tr("Franais") );
    frenchAction->setMenuText( tr("&Franais") );

    englishAction->setText( tr("English") );
    englishAction->setMenuText( tr("&English") );
    
    if (MenuBar->findItem(1))
        MenuBar->findItem(1)->setText( tr( "Fichier" ) );
    if (MenuBar->findItem(2))
        MenuBar->findItem(2)->setText( tr( "Traitement" ) );
    if (MenuBar->findItem(3))
        MenuBar->findItem(3)->setText( tr( "Aide" ) );
    if (MenuBar->findItem(4))
        MenuBar->findItem(4)->setText( tr( "Langue" ) );
	
	    MenuBar->update();
}



void Form1::english()
{
	setCaption( tr( "Image Processing Project: Tophat Filter " ) );
    stats->setTitle( tr( "Statistics - Evolution" ) );
  //  fileNewAction->setText( tr( "New" ) );
   // fileNewAction->setMenuText( tr( "&New" ) );
   // fileNewAction->setAccel( tr( "Ctrl+N" ) );
    
    fileOpenAction->setText( tr( "Open" ) );
    fileOpenAction->setMenuText( tr( "&Open..." ) );
    fileOpenAction->setAccel( tr( "Ctrl+O" ) );

    fileSaveAction->setText( tr( "Save" ) );
    fileSaveAction->setMenuText( tr( "&Save" ) );
    fileSaveAction->setAccel( tr( "Ctrl+S" ) );
    
    fileSaveAsAction->setText( tr( "Save As" ) );
    fileSaveAsAction->setMenuText( tr( "Save As" ) );
    fileSaveAsAction->setAccel( QString::null );
    
    filePrintAction->setText( tr( "Print" ) );
    filePrintAction->setMenuText( tr( "&Print..." ) );
    filePrintAction->setAccel( tr( "Ctrl+P" ) );
    
    
    fileExitAction->setText( tr( "Quit" ) );
    fileExitAction->setMenuText( tr( "Quit" ) );
    fileExitAction->setAccel( tr( "Ctrl+Q" ) );
    
    helpContentsAction->setText( tr( "Contents" ) );
    helpContentsAction->setMenuText( tr( "&Contents..." ) );
    helpContentsAction->setAccel( tr( "Ctrl+C" ) );
    
    helpIndexAction->setText( tr( "Index" ) );
    helpIndexAction->setMenuText( tr( "&Index..." ) );
    helpIndexAction->setAccel( tr( "Ctrl+I" ) );
    
    helpAboutAction->setText( tr( "About" ) );
    helpAboutAction->setMenuText( tr( "&About" ) );
    helpAboutAction->setAccel( tr( "Ctrl+A" ) );
    
    traitementProcederAction->setText( tr( "Execute" ) );
    traitementProcederAction->setMenuText( tr( "Execute" ) );
    traitementProcederAction->setAccel( tr( "Ctrl+R" ) );
        
    traitementIntermdiairesAction->setText( tr("Intermedaire") );
    traitementIntermdiairesAction->setMenuText(tr("Intermedaire") );
    
    frenchAction->setText( tr("Franais") );
    frenchAction->setMenuText( tr("&Franais") );

    englishAction->setText( tr("English") );
    englishAction->setMenuText( tr("&English") );
    
   
    if (MenuBar->findItem(1))
	MenuBar->findItem(1)->setText( tr( "File" ) );
    if (MenuBar->findItem(2))
        MenuBar->findItem(2)->setText( tr( "Processing" ) );
    if (MenuBar->findItem(3))
        MenuBar->findItem(3)->setText( tr( "Help" ) );
    if (MenuBar->findItem(4))
        MenuBar->findItem(4)->setText( tr( "Language" ) );

    MenuBar->update();

}


