#include <ctime>
#include <list>

#include "image.h"


long maxType(size_t type)
{
	switch(type)
	{
		case sizeof(UCHAR) : return UCHAR_MAX;
		case sizeof(USHORT) : return UCHAR_MAX;
		case sizeof(ULONG) : return UCHAR_MAX;
		default: throw(1);
	}
	return 0;
}

/* --- Classe ImageCouleur --- */

ImgCouleur::ImgCouleur(unsigned w, unsigned h) : Image<ULONG>(w, h)
{}

ImgCouleur::ImgCouleur(const ImgCouleur& src) : Image<ULONG>((Image<ULONG>)src)
{}

ImgCouleur::~ImgCouleur()
{
#ifdef WIN32
	Image<ULONG>::~Image<ULONG>();
#else
	this->~Image<ULONG>();
#endif
}

ImgCouleur& ImgCouleur::operator =(const ImgCouleur& src)
{
	(*this).Image<ULONG>::operator =((Image<ULONG>)src); 
	return (*this);
}

bool ImgCouleur::savePPM(const char* fic) const
{
	char tmp(0);
	ofstream flot(fic, ios::out | ios::binary);

	flot << "P6\n";
	flot << width << " " << height << '\n';
	flot << "255\n";

	for(int i(0);i<width*height;i++)
	{
		tmp = ((ULONG)*(_data + i) >> 16);
		flot.write((char*)&tmp, sizeof(char));
		tmp = ((ULONG)*(_data + i) >> 8);
		flot.write((char*)&tmp, sizeof(char));
		tmp = ((ULONG)*(_data + i)) ;
		flot.write((char*)&tmp, sizeof(char));
	}

	flot.close();
	
	return true;
}

bool ImgCouleur::loadPPM(const char* fic)
{

	UCHAR col;
	ULONG red, blue, green;
	string format;
	string nb_col;

	ifstream flit(fic, ios::in | ios::binary);

	flit >> format;

	if(format == "P6")
	{
		flit >> width;
		flit >> height;
		flit >> nb_col;

		char nbsp;

		alloc(width, height);

		flit.read(&nbsp, sizeof(char));

		for(int i(0);i<width*height;i++)
		{ 
			flit.read((char*)&col, sizeof(UCHAR));
			red = (ULONG)col;
			flit.read((char*)&col, sizeof(UCHAR));
			green = (ULONG)col;
			flit.read((char*)&col, sizeof(UCHAR));
			blue = (ULONG)col;
	 
			*(_data + i) = (red << 16) + (green << 8) + blue;
		}
	}

	flit.close();

	return true;
}


//Nettoyage  la charge du programmeur !!!

sig1D<ULONG>* ImgCouleur::histogramme() const
{
	sig1D<ULONG>* histo = new sig1D<ULONG> [3];

	histo->alloc(256);
	(histo+1)->alloc(256);
	(histo+2)->alloc(256);

	for(int i(0);i<3;i++)
		(histo + i)->set((ULONG)0);

	ULONG* pt_red = histo[0].ptr;
	ULONG* pt_green = histo[1].ptr;
	ULONG* pt_blue = histo[2].ptr;

	for(int i(0); i<width*height;i++)
	{
		++(pt_red[(*(_data + i)) >> 16]);
		++(pt_green[((*(_data + i)) >> 8) & 0x000000ff]);
		++(pt_blue[(*(_data + i)) & 0x000000ff]);
	}

	
	return histo;
}

ImgCouleur* ImgCouleur::traceHisto(unsigned nbc, unsigned nbl) const
{
	sig1D<ULONG>*	histo = histogramme();
	ImgCouleur*		tab_hist = new ImgCouleur[3];
	ULONG			red(255 << 16);
	ULONG			green(255 << 8);
	ULONG			blue(255);
	ULONG			tab_col[3] = { red, green, blue };
	ULONG*			act_col = tab_col;

	for(int i(0);i<3;i++)
	{
		(tab_hist+i)->alloc(nbc, nbl);
		(tab_hist+i)->set((ULONG)NOIR);
	}

	for(int j(0);j<3;j++, act_col++)
	{
		long maxi((histo+j)->getMax());
		double rapport;

		rapport = 255. / (double)maxi;

		for(int k(0);k<(int)nbc;k++)
			for(int l(0);l<(int)(*((histo+j)->ptr+k) * rapport);l++)
				*((tab_hist+j)->_data + (255-l)*nbc+k) = *act_col;
	}

	if(histo)
		delete[] histo;
	histo = NULL;

	return tab_hist;
}
///////////////////////////////////// ELEMENT STRUCTRANT /////////////////////////////////

template <class T>
int EStruct::operator ()(int a, int b, const Image<T>& img) const
{
	assert(a < img.height && b < img.width && a >=0 && b >= 0);
	int res;
/*
	for(int i(0);i<dim;i++)
		for(int j(0);j<dim;j++)
			res +=  ( (mat[i][j]) * (int)*(img._data +(a+i)*img.width + j+b) );
*/
	return res;
}

EStruct::EStruct(unsigned d, const double& c) : dim(d), coef(c)
{
	mat = NULL;
	if(d)
	{
		mat = new int[d*d];
		for(int i(d*d);i--;)
			*(mat + i) = 0;
	}
}

EStruct::EStruct(const EStruct& elem) : dim(elem.dim), coef(elem.coef)
{
	mat = NULL;
	if(dim)
	{
		mat = new int[dim*dim];
		for(int i(dim*dim);i--;)
			*(mat + i) = *(elem.mat + i);
	}
}

EStruct::~EStruct()
{
	if(mat)
		delete[] mat;
	mat = NULL;
}

void EStruct::setDim(unsigned nDim)
{
	dim = nDim;

	if(dim)
	{
		mat = new int[dim*dim];
		for(int i(dim*dim);i--;)
			*(mat + i) = 0;
	}
}


EStruct& EStruct::operator =(const EStruct& elem)
{
	mat  = NULL;
	dim  = elem.dim;
	coef = elem.coef;

	if(dim)
	{
		mat = new int[dim*dim];
		for(int i(dim*dim);i--;)
			*(mat + i) = *(elem.mat + i);
	}

	return (*this);
}

int* EStruct::operator [](unsigned i)
{
	return (mat+i*dim);
}

int* EStruct::operator [](unsigned i) const
{
	return (mat+i*dim);
}


void EStruct::set(int val)
{
	for(unsigned i(0);i<dim*dim;i++)
		*(mat + i) = val;
}

/////////////////////////////////////////////////////

ImgCouleur ImgCouleur::Colorisation(Image<UCHAR>& src, Stat& stat_img)
{
	int cpt_reg(0), sommet;
	static int graine = time(NULL);
	static bool first = true;
	ImgCouleur res(src.width, src.height);
	list<int> lVx;
	region reg;

	for(int i(0);i<src.width*src.height;i++)
		*(res._data + i) = (200 << 16) + (200 << 8) + 200;

	if(first)
	{
		first = false;
		srand(graine);
	}

	ULONG r(0), g(255), b(0), col(0);

	for(int j(0);j<src.width*src.height;j++)
	{
		if(*(src._data+j) == (UCHAR)BLANC)
		{
			reg = region();

			sommet = j;
			lVx.push_back(sommet);

			r = rand() % 255 + 1;
			g = rand() % 255 + 1;
			b = rand() % 255 + 1;

			col = (r << 16) + (g << 8) + b;

			++cpt_reg;

			int tmp = 0;

			while(!lVx.empty())
			{
				++tmp;
				sommet = lVx.back();
				lVx.pop_back();
				reg.addPixel();

				*(res._data+sommet) = col;
				*(src._data+sommet) = NOIR;

				if((sommet + src.width) < src.width*src.height && ((int)*(src._data+sommet + src.width)) == 255)
					lVx.push_back(sommet+src.width);
				if((sommet - src.width) >= 0 && ((int)*(src._data+sommet-src.width)) == 255)
					lVx.push_back(sommet-res.width);
				if(sommet + 1 < src.width*src.height && ((int)*(src._data+sommet+1)) == 255)
					lVx.push_back(sommet+1);
				if(sommet - 1 >= 0 && ((int)*(src._data+sommet-1)) == 255)
					lVx.push_back(sommet-1);	
			}

			if(tmp == 1)
			{
				--cpt_reg;
				*(res._data+sommet) = (200 << 16) + (200 << 8) + 200;
			}
			else
				stat_img.addRegion(reg);
		}
	}

	//cout << "Population detectee: " << cpt_reg << endl;

	return res;
}
