
#include "histopop.h"

#include <qgroupbox.h>
#include <qlabel.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qimage.h>
#include <qpixmap.h>


void HistoPop::setPixmap( const QPixmap & _p, unsigned ind )
{ 
    if(ind < 2)
    {
	switch(ind)
	{
	case 0: labHistp1->setPixmap(_p); break;
	case 1: labHistp2->setPixmap(_p); break;
	default: break;
	}
    }
}


QTextEdit* HistoPop::getTxtZone()
{
    return result;
}



/*
 *  Constructs a HistoPop as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
HistoPop::HistoPop( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	  name= "HistoPop";

    histp1 = new QGroupBox( this, "histp1" );
    histp1->setGeometry( QRect( 30, 40, 280, 280 ) );

    labHistp1 = new QLabel( histp1, "labHistp1" );
    labHistp1->setGeometry( QRect( 10, 20, 256, 256 ) );

    histp1_2 = new QGroupBox( this, "histp1_2" );
    histp1_2->setGeometry( QRect( 340, 40, 280, 280 ) );

    labHistp2 = new QLabel( histp1_2, "labHistp2" );
    labHistp2->setGeometry( QRect( 10, 20, 256, 256 ) );

    result = new QTextEdit( this, "result" );
    result->setGeometry( QRect( 160, 360, 330, 112 ) );
    result->setPaletteBackgroundColor( QColor( 236, 233, 215 ) );
    result->setFrameShape( QTextEdit::NoFrame );
    result->setReadOnly( TRUE );
    result->setUndoRedoEnabled( TRUE );
    languageChange();
    resize( QSize(646, 489).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
}

/*
 *  Destroys the object and frees any allocated resources
 */
HistoPop::~HistoPop()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void HistoPop::languageChange()
{
    setCaption( tr( "Form1" ) );
    histp1->setTitle( tr( "Population avant pluies" ) );
    labHistp1->setText( QString::null );
    histp1_2->setTitle( trUtf8( "\x50\x6f\x70\x75\x6c\x61\x74\x69\x6f\x6e\x20\x61\x70\x72\xc3\xa8\x73\x20\x70\x6c\x75\x69\x65\x73" ) );
    labHistp2->setText( QString::null );
}

