
#include "image.h"

#include <qcolor.h>
#include <qimage.h>
#include <qwmatrix.h> 
#include <qpixmap.h>


QPixmap MyImage2QPixmap(Image<UCHAR>& pt_img)
{
	QPixmap img_tmp;
	
	QRgb* _rgb;

	_rgb = new QRgb[256];

	for(int i=0;i<256;i++)
		_rgb[i] = qRgb(i,i,i);

	QImage img_reel(pt_img.getBuffer(), pt_img.getWidth(), pt_img.getHeight(), 8, _rgb, 256, QImage::IgnoreEndian);

	if(!img_reel.isNull())
		img_tmp.convertFromImage(img_reel);
	
	if(_rgb)
		delete[] _rgb;

	return img_tmp;
}

QPixmap MyImage2QPixmap(Image<UCHAR>* pt_img)
{
	QImage img_reel(pt_img->getWidth(), pt_img->getHeight(), 8, 256, QImage::IgnoreEndian);
	QPixmap pix;
	QWMatrix m;
	int col_tmp;

	m.scale(0.5, 0.5);
	for(int i(0);i<256;i++)
		img_reel.setColor(i, qRgb(i, i, i));

	for(int j(0);j<pt_img->getHeight();j++)
		for(int k(0);k<pt_img->getWidth();k++)
		{
			col_tmp = ((int) ( *( pt_img->getBuffer()+j*( pt_img->getWidth() ) +k )));
			img_reel.setPixel(k, j, qGray(col_tmp, col_tmp, col_tmp));
		}

	pix.convertFromImage(img_reel);
	pix = pix.xForm(m);
	return pix;
}

QPixmap MyImage2QPixmap(ImgCouleur* pt_img)
{
	QImage img_reel(pt_img->getWidth(), pt_img->getHeight(), 32, 256, QImage::IgnoreEndian);
	QPixmap pix;
	QWMatrix m;
	m.scale(0.5, 0.5);

	for(int i(0);i<256;i++)
		img_reel.setColor(i, qRgb(i, i, i));

	for(int j(0);j<pt_img->getHeight();j++)
		for(int k(0);k<pt_img->getWidth();k++)
			img_reel.setPixel(k, j, qRgb(pt_img->getRed(j*pt_img->getWidth()+k), pt_img->getGreen(j*pt_img->getWidth()+k), pt_img->getBlue(j*pt_img->getWidth()+k)));

	pix.convertFromImage(img_reel);
	pix = pix.xForm(m);
	
	return pix;
}
