#include "TraitThread.h"
#include "image.h"
#include "region.h"

#include <qdatetime.h>
#include <qfile.h>
#include "main_win.h"
//#include "fonction.h"
ThreadImg1::ThreadImg1(Form1* f)
{father=f;}
void ThreadImg1::run() ///// First Image /////
{
	(*(father->sem))++;
	int popul;
	Stat img_stat;
	EStruct elem(9), elem2(13), elem3(3), elem4(5), elem5(3), elem6(3);
	
	ImgCouleur img1;
	QString tmp;

	QFile flit("./res/cur_proj");
	flit.open(IO_ReadOnly | IO_Translate);
	flit.readLine(tmp, 256);
	tmp.remove('\n');
	flit.close();
	img1.loadPPM(tmp.ascii());

	elem.set(1);
	elem2.set(1);
	elem3.set(1);
	elem4.set(1);
	elem5.set(0);
	elem6.set(0);

	elem5[1][0] = elem5[1][1] = elem5[1][2] = 1;
	elem6[0][1] = elem6[1][1] = elem6[2][1] = 1;

	Image<UCHAR> tmp1(img1.getLum()), trans1, trans2, anam(tmp1.anamorphose());
	trans1 = anam.chapeauHaut(elem2, NOIR).seuillageMin(50);
	trans2 = (anam.seuillageMin(anam.getSeuilMin()).dilatation(elem3)+ trans1);
	trans2.traceBordure(5);

	ImgCouleur img_coul(ImgCouleur::Colorisation(trans2, img_stat));

	ofstream rap1("./res/rapport1", ios::out );
	rap1<<img_stat.getNbRegion()<<endl<<img_stat.getBigger()<<endl<<img_stat.getRayMax()<<endl<<img_stat.moyenne()<<endl;
	rap1.close();

	tmp1.save("./res/sousf0.ppm");
	img_coul.savePPM("./res/sousf2.ppm");


	int nbclass(15);
	sig1D<ULONG> histpop(nbclass), popclass(nbclass);
	histpop.set(0);

	for(int i(1);i<=nbclass;i++)
		*(popclass.ptr+i-1) = 1000*i;


	for(list<region>::iterator it = img_stat.lReg.begin();it!=img_stat.lReg.end();it++)
	{
		popul = (*it).getNbPixel();

		for(int aa(0);aa<nbclass;aa++)
			if((ULONG)popul <= *(popclass.ptr+aa))
			{
				++(*(histpop.ptr+aa));
				break;
			}
	}

	Image<UCHAR> imgPop(256, 256);
	imgPop.set((UCHAR)NOIR);

	for(int bb(1);bb<=nbclass;bb++)
		for(unsigned i(0);i<*(histpop.ptr+bb-1)*10 && i < 256;i++)
			*(imgPop._data+i*256+bb*15) = (UCHAR)BLANC;
	
	imgPop.mirror().save("./res/imgPop1.ppm");
	(*(father->sem))--;
	terminate();	
	
}

ThreadImg2::ThreadImg2(Form1 *f)
{father=f;}

void ThreadImg2::run() ///// Second /////
{
	(*(father->sem2))++;
	int popul2,nbclass2(15);
	EStruct elem(9), elem2(13), elem3(3), elem4(5), elem5(3), elem6(3);
	Stat img_stat2;
	ImgCouleur img2;
	
	QString tmp;
	QFile flit("./res/cur_proj");
	flit.open(IO_ReadOnly | IO_Translate);
	flit.readLine(tmp, 256);
	flit.readLine(tmp, 256);
	flit.close();
	tmp.remove('\n');
	img2.loadPPM(tmp.ascii());

	elem.set(1);
	elem2.set(1);
	elem3.set(1);
	elem4.set(1);
	elem5.set(0);
	elem6.set(0);

	elem5[1][0] = elem5[1][1] = elem5[1][2] = 1;
	elem6[0][1] = elem6[1][1] = elem6[2][1] = 1;


	Image<UCHAR> tmp2(img2.getLum()), trans12, trans22, anam2(tmp2.anamorphose());

	anam2 = tmp2.anamorphose();
	trans12 = anam2.chapeauHaut(elem2, NOIR).seuillageMin(60);
	trans22 = (anam2.seuillageMin(anam2.getSeuilMin()-5)+ trans12);
	trans22.traceBordure(5);

	img_stat2.reset();

	ImgCouleur img_coul2(ImgCouleur::Colorisation(trans22, img_stat2));

	sig1D<ULONG> histpop2(nbclass2), popclass2(nbclass2);	
	histpop2.set(0);

	for(int i(1);i<=nbclass2;i++)
		*(popclass2.ptr+i-1) = 1000*i;

	for(list<region>::iterator it = img_stat2.lReg.begin();it!=img_stat2.lReg.end();it++)
	{
		popul2 = (*it).getNbPixel();

		for(int aaa(0);aaa<nbclass2;aaa++)
		{
			if((ULONG)popul2 <= *(popclass2.ptr+aaa))
			{
				++(*(histpop2.ptr+aaa));
				break;
			}
			if(aaa == nbclass2-1)
				++(*(histpop2.ptr+aaa));
		}
	}
	tmp2.save("./res/sousf1.ppm");
	img_coul2.savePPM("./res/sousf3.ppm");
    
	Image<UCHAR> imgPop2(256, 256);
	imgPop2.set((UCHAR)NOIR);

	for(int bb(1);bb<=nbclass2;bb++)
		for(unsigned i(0);i<*(histpop2.ptr+bb-1)*10 && i < 256;i++)
			*(imgPop2._data+i*256+bb*15) = (UCHAR)BLANC;

    	imgPop2.mirror().save("./res/imgPop2.ppm");
	
	ofstream rap2("./res/rapport2", ios::out );
	rap2<<img_stat2.getNbRegion()<<endl<<img_stat2.getBigger()<<endl<<img_stat2.getRayMax()<<endl<<img_stat2.moyenne()<<endl;
	rap2.close();
	(*(father->sem2))--;
	terminate();
	

}
