/**
 * Class TextFile
 * Description : this class is a text file
 * @author Cyril RABAT
 * <p> University of Rheims Champagne-Ardenne
 */

import java.io.*;

public class TextFile
{
	// File
	private RandomAccessFile file;
	// Name of file
	private String nameFile;
	// Open method
	private int open;
	
	//
	// CONSTRUCTORS
	//
	
	/**
	 * Constructeur
	 * @param nameFile name of the file to open/create
	 */
	public TextFile(String nameFile)
	{
		this.nameFile = new String(nameFile);
		this.open = 0;
	}
	
	//
	// GETTERS
	//
	
	/**
	 * Return the name of file
	 * @return name of file
	 */
	public String getNameFile()
	{
		return new String(this.nameFile);
	}
	
	/**
	 * Return if the file is opened
	 * @return TRUE if the file is opened
	 */
	public boolean isOpen()
	{
		return open!=0;
	}
	
	/** 
	 * Return the length of the file
	 * @return length of the file, -1 if an error occurs
	 */
	public long getLength()
	{
		long result = -1;
		
		if(open!=0) {
			try {
				result = file.length();
			} catch(IOException e) {
				result = -1;
			}			
		}
		return result;
	}
	
	/**
	 * Return the current position inside the file
	 * @return position courante
	 */
	public long getPosition()
	{
		long position = -1;
		
		if(this.open!=0) {
			try {
				position = file.getFilePointer();
			} catch(IOException e) {
				position = -1;
			}
		}
		return position;
	}
	
	//
	// SETTERS
	//
	
	/**
	 * Change the file name
	 * @return TRUE if succes
	 */
	public boolean setNameFile(String nameFile)
	{
		boolean result = true;
				
		if(open!=0) {
			result = this.close();
		}		
		if(result==true) {
			this.nameFile = new String(nameFile);
		}
		return result;
	}
	
	//
	// OTHER METHODS
	//
	
	/**
	 * Open file in read mode
	 * @return TRUE if succes
	 */
	 public boolean openRead()
	 {
	 	boolean result = true;	 	
	 
	 	if(open!=0) {
	 		result = close();	 		
	 	}
	 	
	 	if(result==true) {
	 		try {	 	 		 	
	 			file = new RandomAccessFile(nameFile,"r");
	 			result = true;
	 			this.open = 1;
	 		} catch(IOException e) {
	 			result = false;	 		
	 		}
	 	}
	 	return result;
	 }
	 
	 /**
	 * Open file in write mode
	 * @return TRUE if succes
	 */
	 public boolean openWrite()
	 {
	 	boolean result = true;
	 	
	 	if(open!=0) {
	 		result = close();	 		
	 	}
	 	
	 	if(result==true) {
	 		try {	 	 		 	
	 			file = new RandomAccessFile(nameFile,"rw");
	 			file.setLength(0);
	 			result = true;
	 			this.open = 2;
	 		} catch(IOException e) {
	 			result = false;	 		
	 		}
	 	}
	 	return result;
	 }
	 
	 /**
	  * Close file
	  * @return TRUE if succes
	  */
	 public boolean close()
	 {
	 	boolean result = false;
	 	
	 	if(this.open!=0) {
	 		try {
	 			file.close();
	 			open = 0;
	 			result = true;
	 		} catch(IOException e) {
	 			result = false;	 			
	 		}
	 	}
	 	return result;
	 }	
	 
	 /**
	  * Return the current position is at end of file
	  * @return TRUE if end of file
	  */
	 public boolean eof() {
	 	boolean result = true;
	 	
	 	if(open!=0) {
	 		long l = getLength();
	 		long p = getPosition();
	 		
 			result = ((p==-1)||(l==-1)||(l==p));
	 	}
	 	return result;
	 }
	 
	 /**
	  * Read a string into the file
	  * @return string readed
	  */
	 public String readString() {
	 	String line = null;
	 	
	 	if(this.open==1) {
	 		try {
	 			line = file.readLine();
			} catch(IOException e) {
				line = null;
			}
	 	}
	 	return line;
	 }
	 
	 /**
	  * Write a string into the file
	  * @param str string to write
	  * @return TRUE if succes
	  */
	 public boolean writeString(String str) {
	 	boolean result = false; 	
	 	
	 	if(this.open==2) {
	 		try {	 			
	 			file.writeBytes(str);			
				result = true;
			} catch(IOException e) {
				result = false;
			}
	 	}
	 	return result;
	 }
}