/**
 * Class RandomValue
 * Description : gives random numbers
 * @author Cyril Rabat
 * <p> University of Rheims Champagne-Ardenne
 */
 
 public class RandomValue {
	/**
	 * Return a random integer in the interval [lowerBound; upperBound]
	 * @param lowerBound the lower bound of the interval
	 * @param upperBound the upper bound of the interval
	 * @return random integer
	 */
	static int integer(int lowerBound, int upperBound)
	{
		return (int)((upperBound-lowerBound+1)*Math.random()+lowerBound);
	}
	
	/**
	 * Return a random integer in the interval [0; 100]
	 * @return entier alatoire
	 */
	static int integer()
	{
		return integer(0,100);
	}
	
	/**
	 * Return a random real in the interval [lowerBound; upperBound[
	 * @param lowerBound the lower bound of the interval
	 * @param upperBound the upper bound of the interval
	 * @return random real
	 */
	static double real(double lowerBound, double upperBound)
	{
		return (upperBound-lowerBound)*Math.random()+lowerBound;
	}
	
	/**
	 * Return a random real in the interval [0;1[
	 * @return random real
	 */
	static double real()
	{
		return Math.random();
	}
}