/**
 * Class NetworkPosition
 * Description : this class places nodes of a network
 * @author Cyril Rabat
 * <p> University of Rheims Champagne-Ardenne
 */
 
public class NetworkPosition {
	/**
	 * Node in circle
	 * @param n network which you want to place nodes
	 */
	public static void circle(Network n) {
		double r = (double)(n.getArea()[0]-30/Network.coefX)/2.0;
		int i;
		
		for(i=0;i<n.getNbNodes();i++) {
			n.setPositionNode(i, r+r*Math.sin((double)i*2.0*Math.PI/(double)n.getNbNodes()),
								r+r*Math.cos((double)i*2.0*Math.PI/(double)n.getNbNodes()));
		}
	}
	
	/**
	 * Nodes in grid
	 * @param n network which you want to place nodes
	 */
	public static void grid(Network n) {
		double unitX, unitY, x, y, j=1.0;
		while( (j*j)<n.getNbNodes() )
      j++;
		
		unitX = n.getArea()[0] / j;
		unitY = n.getArea()[1] / j;
		
		x = 0.0;
		y = 0.0;
		for(int i=0;i<n.getNbNodes();i++)
    {
			n.setPositionNode(i, x*unitX, y*unitY);
			x++;
			if(x==j)
      {
				x = 0;
				y++;
			}
		}
	}
	
	/**
	 * Nodes in random positions
	 * @param n network which you want to place nodes
	 */
	public static void random(Network n) {
		int i;
		double x, y;
		
		for(i=0;i<n.getNbNodes();i++) {
			x = RandomValue.real(0+30/Network.coefX, n.getArea()[0]-30/Network.coefX);
			y = RandomValue.real(0+30/Network.coefX, n.getArea()[1]-30/Network.coefX);
			n.setPositionNode(i, x, y);
		}
	}
}
