/**
 * Class NetworkLink
 * Description : this class set nodes links of a network in special topology 
 * @author Cyril Rabat
 * <p> University of Rheims Champagne-Ardenne
 */
 
public class NetworkLink {
	
	/**
	 * Set the nodes of a network n into a directed ring
	 */
	public static void ringDirected(Network n) {
		n.setOptions(true, true, false);
		n.emptyLink();
		for(int i=0;i<n.getNbNodes()-1;i++)
			n.addLink(i, i+1, 1);
		n.addLink(n.getNbNodes()-1, 0, 1);
	}
	
	/**
	 * Set the nodes of a network n into an undirected ring
	 */
	public static void ringUndirected(Network n) {
		n.setOptions(true, false, false);
		n.emptyLink();
		for(int i=0;i<n.getNbNodes()-1;i++)
	    {
           n.addLink(i, i+1, 1);
           n.addLink(i+1, i, 1);
        }

		n.addLink(n.getNbNodes()-1, 0, 1);
	   n.addLink(0, n.getNbNodes()-1, 1);
	}
	
	/**
	 * Set the nodes of a network n as a complete graph
	 */
	public static void complete(Network n) {
		int i,j;
		
		n.setOptions(true, false, false);
		n.emptyLink();
		for(i=0;i<n.getNbNodes()-1;i++)
			for(j=i+1;j<n.getNbNodes();j++)
				n.addLink(i, j, 1);		
	}
	
	/**
	 * Set the nodes of a network n as a star
	 */
	public static void star(Network n) {
		int i;
		
		n.setOptions(true, false, false);
		n.emptyLink();
		for(i=1;i<n.getNbNodes();i++)
			n.addLink(0, i, 1);
	}
	
	/**
	 * Set the nodes of a network n into random positions
	 * @param n which you want to add links
	 * @param p it's the probability to have a link between two nodes
	 */
	public static void random(Network n, double p) {
		int i,j;
		
		n.setOptions(true, false, false);
		n.emptyLink();
		
		for(i=0;i<n.getNbNodes()-1;i++)
			for(j=i+1;j<n.getNbNodes();j++) 
			{
				if(RandomValue.real()<=p)
				{	n.addLink(i, j, 1);	}
			}
		if( n.getNbNodes() >0 )  
			n.setConnexe();
	}
}
