/**
 * Class NetworkFile
 * Description : this class permits to load a network from file and to save it into a file
 * @author Cyril Rabat
 * <p> University of Rheims Champagne-Ardenne
 */
 
import java.util.*;

public class NetworkFile {
	public final static String[] KEYWORDS = { "NODES=", "OPTIONS=", "AREA=", "POSITION:", "POSITION=",
	                                           "LINK:", "ADJMAT:" };
	public final static String[] OPTIONS = { "UNDIRECTED", "DIRECTED", "UNVALUED", "VALUED", "WIRED", "WIRELESS" };
	public final static String[] POSITIONS = { "CIRCLE", "GRID", "RANDOM" };
	public final static String[] LINKS = { "COMPLETE", "STAR", "DIRECTED RING", "UNDIRECTED RING", "RANDOM" };
		
	/**
	 * Save network in file
	 * @param nameFile name of the file to create
	 * @result TRUE if sucess
	 */
	public static boolean saveFile(Network n, String nameFile) {
		TextFile f;
		String tmp;
		double[] tmpArray;
		double[] position;   ////////////////////////////
						
		f = new TextFile(nameFile);
		f.openWrite();
		// Header
		f.writeString("[GRAPH]\n");
		f.writeString("Nodes="+n.getNbNodes()+"\n");
		tmpArray = n.getArea();
		if(tmpArray.length==2)
			f.writeString("Area="+tmpArray[0]+","+tmpArray[1]+"\n");
		else
			f.writeString("Area="+tmpArray[0]+","+tmpArray[1]+","+tmpArray[2]+"\n");
		tmp = "Options= ";
		if(n.isUnidirectional())
			tmp += "directed, ";
		else
			tmp += "undirected, ";
		if(n.isValued())
			tmp += "valued, ";
		else
			tmp += "unvalued, ";
		if(n.isWired())
			tmp += "wired\n";
		else
			tmp += "wireless\n";
		f.writeString(tmp);
		// Positions
		for(int i=0;i<n.getNbNodes();i++) {
        position = ((DASOR_Node)(n.liste.get(i))).getPos();     ////////////
      if(tmpArray.length==2)			
				f.writeString("Position:"+i+"="+position[0]+","+position[1]+"\n");
			else
				f.writeString("Position:"+i+"="+position[0]+","+position[1]+","+position[2]+"\n");
		}
		// Links
		f.writeString("Adjmat:\n"+n.adjMat);
		f.close();
		
		return true;
	}
		
	/**
	 * Load network from a file
	 * @param nameFile name of the file which contains the network
	 * @return network readed
	 */
	public static Network loadFile(String nameFile) {
		TextFile f;
		String tmpStr;		
		Network n = new Network(10);

		f = new TextFile(nameFile);
		f.openRead();
		tmpStr = f.readString().toUpperCase();
		if(!tmpStr.equals("[GRAPH]")) {
			System.out.println("Invalid network file. [GRAPH] doesn't find at begin of the file");
			System.exit(-1);			
		}
		f.close();
		return n;
	}
}
