import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.*;

public class Network extends JPanel
{
   // Number of nodes into the network
	 private int nbNodes;
   public ArrayList liste;
   public DASOR_AdjMatrix adjMat;
   private NeighList neighList;
	// Area which contains nodes
	 private double[] area;

	// Options of the network
	private boolean wired;
	private boolean unidirectional;
	private boolean valued;

  public DASOR_Link tmpLink;
  public boolean tmpLinkRepaint;
   
  public static double coefX;
  public static double coefY;

////////////CONSTRUCTEUR///////////////
Network ()
    {
      nbNodes=0;
      liste = new ArrayList();
      adjMat = new DASOR_AdjMatrix(0);
      tmpLink = new DASOR_Link();
      neighList = new NeighList(nbNodes);
      tmpLinkRepaint = false;
      setOptions(true, false, false);
      setArea(50,50);
      coefX=500.0/getArea()[0];
		  coefY=570.0/getArea()[1];
    }

Network (int nb)
    {
      setNbNodes(nb);
      setOptions(true, false, false);
      setArea(50,50);
      coefX=500.0/getArea()[0];
		  coefY=570.0/getArea()[1];
    }
    
/////////////////GETTERS/////////////////
/**
	 * Return the number of nodes
	 * @return number of nodes
	 */
public int getNbNodes()
{
		return this.nbNodes;
}

public int getNode(double x, double y)
{
  for (int i=0; i < liste.size(); i++)
          {
            DASOR_Node node = (DASOR_Node)liste.get(i);
            if ( x>=node.getX() && x<=node.getX()+(30/Network.coefX))
                if ( y>=node.getY() && y<=node.getY()+(30/Network.coefY))
                    return i;
          }
   return -1;
}

public DASOR_Link getLink(double x, double y)
{
 return (adjMat.getLinkClicked(x,y));
}

public DASOR_Link getLink(int node1, int node2)
{
 return (adjMat.getLink(node1,node2));
}

/**
	 * Return the node i
	 * @param id identity of the node which is returned
	 * @return reference on the node i
	 */
public DASOR_Node getObjNode(int num)
{
   if ( num < liste.size() )
    {
       return (DASOR_Node)liste.get(num);
    }
  else return null;
}

/**
	 * Return the area of the network
	 * @return a tabular that contain dimension of the area
	 */
	public double[] getArea() {
		double[] tmp = new double[area.length];
		int i;

		for(i=0;i<area.length;i++)
			tmp[i] = area[i];
		return tmp;
	}

////////////////SETTERS////////////////
  /**
	 * Set the network options
	 * @param wired TRUE if the network is wired
	 * @param unidirectional TRUE if the network is unidirectional
	 * @param valued TRUE if the network is valued
	 */
	public void setOptions(boolean wired, boolean unidirectional, boolean valued) {
		this.wired = wired;
		this.unidirectional = unidirectional;
		this.valued = valued;
	}

	/**
	 * Set the network as wired or wireless
	 * @param wired TRUE if the network is wired
	 */
	public void setWired(boolean wired) {
		this.wired = wired;
	}

	/**
	 * Set the network as unidirectional or bidirectional
	 * @param wired TRUE if the network is unidirectional
	 */
	public void setUnidirectional(boolean unidirectional) {
		this.unidirectional = unidirectional;
	}

	/**
	 * Set the network as valued or not
	 * @param wired TRUE if the network is valued
	 */
	public void setValued(boolean valued) {
		this.valued = valued;
	}

		/**
	 * Set the 3D area of nodes
	 * @param x x dimension
	 * @param y y dimension
	 * @param z z dimension
	 */
	public void setArea(double x, double y, double z) {
		this.area = new double[3];
		area[0] = x;
		area[1] = y;
		area[2] = z;
	}

	/**
	 * Set the 2D area of nodes
	 * @param x x dimension
	 * @param y y dimension
	 */
	public void setArea(double x, double y) {
		this.area = new double[2];
		area[0] = x;
		area[1] = y;
	}

  public void setPosNode( int num, double x, double y)
{
  ((DASOR_Node)liste.get(num)).setPos(x,y);
}

 public void setPositionNode( int num, double x, double y)
{
  ((DASOR_Node)liste.get(num)).setPos(x,y);
}

	/**
	 * Set the number of nodes the a network
	 * @param nbNodes new number of nodes
	 */
	public void setNbNodes(int nbNodes) {
		int i;

		this.nbNodes = nbNodes;
		liste = new ArrayList();
		for(i=0;i<nbNodes;i++) {
      liste.add(new DASOR_Node(i%getArea()[0],getArea()[1]/2));
		}
		adjMat = new DASOR_AdjMatrix(nbNodes);
		neighList = new NeighList(nbNodes);
		tmpLink = new DASOR_Link();
		tmpLinkRepaint = false;
		//setArea(10,100);
	}

//////////////Fct setPosLink////////// Met a jour la position des liens par rapport au noeud
	/**
	 * Updates the graphical links connected to a node
	 * @param node source of the links.
	 */
public void SetPosLink(int node)
{
   double x, y;
   x = ((DASOR_Node)liste.get(node)).getX()+(10.0/Network.coefX);
   y = ((DASOR_Node)liste.get(node)).getY()+(10.0/Network.coefY);

   for(int i=0; i<liste.size(); i++)
    {
      if(i!=node && adjMat.isLink(node,i) )
      (adjMat.getLink(node,i)).setPosStart(x,y);
    }

  for(int i=0; i<liste.size(); i++)
    {
      if(i!=node && adjMat.isLink(i,node) )
      (adjMat.getLink(i,node)).setPosEnd(x,y);
    }

}


	/** Updates all the graphical links	 */
public void setPosAllLink()
{
	for(int i=0;i<nbNodes;i++)
		SetPosLink(i);

}



////////////////////OTHER METHODS////////////////
////////////Pour Dessiner///////////////////
public void paintComponent(Graphics g)
    {
      super.paintComponent(g);

      for (int i=0; i < liste.size(); i++)
           ((DASOR_Node)liste.get(i)).Affiche(g);
      for (int i=0; i < adjMat.getSize(); i++)
          {
            for (int j=0; j < adjMat.getSize(); j++)
              {
                 if (i!=j)
                  {
                    if ( adjMat.getWeight(i,j) > 0 )     //il existe un lien
                      {
                        ((DASOR_Link)(adjMat.getLink(i,j))).Affiche(g,valued);
                      }
                  }
              }
          }
       if(tmpLinkRepaint) tmpLink.Affiche(g,valued);
    }



	/**
	 * Add a node in a "2 dimension" network
	 * @param x .
	 * @param y .
	 */
public void addNode(double x, double y)
{
  nbNodes++;
  adjMat.addNode();
  liste.add(new DASOR_Node(x,y));
  neighList.addNode();
}

/////////////Fct isNode///////////////////
public boolean isNode(double x, double y)
{
    for (int i=0; i < liste.size(); i++)
          {
            DASOR_Node node = (DASOR_Node)liste.get(i);
            if ( x>=node.getX() && x<=node.getX()+(30/Network.coefX))
                if ( y>=node.getY() && y<=node.getY()+(30/Network.coefY))
                    return true;
          }
return false;
}

////////////Suppresion d'un node////////////
public void delNode(double x, double y)
{
int n = getNode(x,y);
if ( n>=0)
   {
     liste.remove(n);
     for (int i=n;i<liste.size();i++)
        ((DASOR_Node)liste.get(i)).reInitialise();

     nbNodes--;
     adjMat.delNode(n);
     InitNeighbor();
   }
}

public void delNode(int n)
{
if ( n<liste.size())
   {
     liste.remove(n);
     if (liste.isEmpty()) (new DASOR_Node(1,2)).initNbNode();
     if( n == nbNodes-1 ) DASOR_Node.setNbNode(nbNodes-1);
     for (int i=n;i<liste.size();i++)
      {
        ((DASOR_Node)liste.get(i)).reInitialise();
      }
     nbNodes--;
     adjMat.delNode(n);
     InitNeighbor();
   }
}

//////////////Fct addLink///////////////////// Ajoute un lien a la matrice d'adjacence
public void addLink(int node1, int node2, int weight)
{
		if((node1>=0)&&(node1<liste.size())&&(node2>=0)&&(node2<liste.size()))
    {
      adjMat.setPos((DASOR_Node)liste.get(node1), (DASOR_Node)liste.get(node2));
      adjMat.setWeight(node1, node2, weight);
      neighList.addNeighbor(node1, node2);
    }
}

	/**
	 * Delete a link between the node1 and the node2
	 * @param node1 the first node
	 * @param node2 the second node
	 */
	public void deleteLink(int node1, int node2)
  {
			adjMat.setWeight(node1, node2, 0);
			neighList.deleteNeighbor(node1, node2);
	}


/////////////fct Initneighbor//////// utiliser pour kan on suprime un noeud
private void InitNeighbor()
{
  neighList = new NeighList(nbNodes);
  for(int i=0; i<nbNodes; i++)
    for(int j=0; j<nbNodes; j++)
    {
      if(adjMat.isLink(i,j) && i!=j)
        {
           neighList.addNeighbor(i,j);
        }
    }
}

	/**
	 * Return a string that represents the network
	 * @return the string
	 */
	public String toString() {
		String s;

		s = "Network : " + nbNodes + " nodes, ";
		if(isWired())
			s += "wired, ";
		else
			s += "wireless, ";
		if(isValued())
			s += "valued, ";
		else
			s += "unvalued, ";
		if (isUnidirectional())
			s += "unidirectional\n";
		else
			s += "bidirectional\n";
		s += "Adjency matrix : \n" + adjMat;
		return s;
	}

  public String toText()
	{
		String tmp;
		double[] tmpArray;
		double[] position;

		tmp = new String();

		// Header
		tmp="[GRAPH]\n";
		tmp+="Nodes="+getNbNodes()+"\n";
		tmpArray = getArea();
		if(tmpArray.length==2)
			tmp+="Area="+tmpArray[0]+","+tmpArray[1]+"\n";
		else
			tmp+="Area="+tmpArray[0]+","+tmpArray[1]+","+tmpArray[2]+"\n";
		tmp += "Options= ";
		if(isUnidirectional())
			tmp += "directed, ";
		else
			tmp += "undirected, ";
		if(isValued())
			tmp += "valued, ";
		else
			tmp += "unvalued, ";
		if(isWired())
			tmp += "wired\n";
		else
			tmp += "wireless\n";
		// Positions
		for(int i=0;i<getNbNodes();i++)
    {
			position = ((DASOR_Node)liste.get(i)).getPos();
			if(tmpArray.length==2)
				tmp+="Position:"+i+"="+position[0]+","+position[1]+"\n";
			else
				tmp+="Position:"+i+"="+position[0]+","+position[1]+","+position[2]+"\n";
		}
		// Links
		tmp+="Adjmat:\n"+adjMat;
		return tmp;

	}


	/**
	 * Return if the network is wired
	 * @return TRUE if the network is wired, FALSE if the network is wireless
	 */
	public boolean isWired() {
		return wired;
	}

	/**
	 * Return if the network is unidirectional
	 * @return TRUE if the network is unidirectional, FALSE if it's bidirectional
	 */
	public boolean isUnidirectional() {
		return unidirectional;
	}

	/**
	 * Return if the network is weighted
	 * @return TRUE if the network is weighted
	 */
	public boolean isValued() {
		return valued;
	}

  	/**
	 * Initialise adjacency matrix
	 */
	public void emptyLink() {
		adjMat.empty();
	}

	/**
	 * Return if the network is connexe
	 * @return TRUE if the network is connexe
	 */
	public boolean isConnexe() {
		byte[] floodingArray;
		int i;
		int tmpNode = 0;
		int neighNode;
		int totalNode = 0;
		LinkedList stack = new LinkedList();
		ListIterator ptr;
		boolean result = true;

		floodingArray = new byte[nbNodes];
		for(i=0;i<nbNodes;i++) {
			floodingArray[i] = 0;
		}

		stack.addFirst(new Integer(0));
		while(stack.size()!=0) {
			tmpNode = ((Integer)stack.getFirst()).intValue();
			stack.removeFirst();
			if(floodingArray[tmpNode]==0) {
				floodingArray[tmpNode] = 1;
				totalNode++;
				ptr = neighList.lst[tmpNode].listIterator();
				while(ptr.hasNext()) {
					neighNode = ((Integer)ptr.next()).intValue();
					if(floodingArray[neighNode]==0)
						stack.addFirst(new Integer(neighNode));
				}
			}
		}

		if(totalNode!=nbNodes) {
			result = false;
		}
		else {
			result = true;
		}
		return result;
	}
	
	
  	/**
	 * Transform network to a connexe one
	 */
	public void setConnexe() {
		byte[] floodingArray;
		int i;
		boolean finish = false;
		int tmpNode = 0;
		int currentNode = 0;
		int totalNode = 0;
		int neighNode;
		LinkedList stack = new LinkedList();
		ListIterator ptr;

		floodingArray = new byte[nbNodes];
		for(i=0;i<nbNodes;i++) {
			floodingArray[i] = 0;
		}

		while(!finish) {
			stack.addFirst(new Integer(currentNode));
			while(stack.size()!=0) {
				tmpNode = ((Integer)stack.getFirst()).intValue();
				stack.removeFirst();
				if(floodingArray[tmpNode]==0) {
					floodingArray[tmpNode] = 1;
					totalNode++;
					ptr = neighList.lst[tmpNode].listIterator();
					while(ptr.hasNext()) {
						neighNode = ((Integer)ptr.next()).intValue();
						if(floodingArray[neighNode]==0)
							stack.addFirst(new Integer(neighNode));
					}
				}
			}
			if(totalNode==nbNodes)
				finish = true;
			else {
				while(floodingArray[currentNode]==1)
					currentNode++;
				addLink(currentNode-1, currentNode, 1);
			}
		}
	}

}//Fin de la classe
