/**
 * Class NeighList
 * Description : this class represents a neighborhood list
 * @author Cyril RABAT
 * <p> University of Rheims Champagne-Ardenne
 */
 
import java.util.*;
 
public class NeighList {
	// List
	LinkedList[] lst;
 	
 	//
 	// CONSTRUCTOR(S)
 	//
 	
 	/**
 	 * Initialisation constructor
 	 * @param nbNodes number of nodes
 	 */
 	public NeighList(int nbNodes) {
 		int i;
 		
 		lst = new LinkedList[nbNodes];
   for(i=0;i<nbNodes;i++) {
 			lst[i] = new LinkedList();
 		}
 	}
 	
 	//
 	// GETTERS
 	//
 	
 	/**
 	 * Return the number of nodes
 	 * @return number of nodes
 	 */
 	public int getNbNodes() {
 		return lst.length;
 	}
 	
 	/**
 	 * Return the number of neighbor of a node
 	 * @param node1 node which you want the neighbor number
 	 * @return number of neighbor
 	 */
 	public int getNbNeighbor(int node1) {
 		int nb = -1;
 		
 		if((node1>=0)&&(node1<lst.length)) {
 			nb = lst[node1].size();
 		}
 		return nb;
 	}
 	
 	//
 	// OTHER METHODS
 	//
 	
 	public void addNode()
    {
      LinkedList[] tmp;
      tmp = lst;
      lst = new LinkedList[tmp.length+1];

      for(int i=0;i<lst.length;i++)
        {
          lst[i] = new LinkedList();
          if( i <tmp.length )
            lst[i] = tmp[i];
        }
    }
 	
 	/**
 	 * Add a new neighbor to a node
 	 * @param node1 node which has the new neighbor
 	 * @param node2 the new neighbor
 	 */
 	public void addNeighbor(int node1, int node2) {
 		if((node1>=0)&&(node1<lst.length)&&(node2>=0)&&(node2<lst.length)) {
 			lst[node1].add(new Integer(node2));
 		}
 	} 	
 	
 	/**
 	 * Delete a neighbor of a node
 	 * @param node1 the node that we want retrive the neighbor
 	 * @param node2 the neighbor
 	 */
 	public void deleteNeighbor(int node1, int node2) {
 		if((node1>=0)&&(node1<lst.length)&&(node2>=0)&&(node2<lst.length)) {
 			lst[node1].remove(new Integer(node2));
 		}
 	}
 	
 	/**
 	 * Return if a node is neighbor of an other node
 	 * @param node1 node that we observe the neighborhood
 	 * @param node2 node which you want to search into the neighborhood of node1
 	 * @result TRUE is node2 is in the neighborhood of node 1
 	 */
 	public boolean isNeighbor(int node1, int node2) {
 		int pos = -1;
 		
 		if((node1>=0)&&(node1<lst.length)&&(node2>=0)&&(node2<lst.length)) {
 			pos = lst[node1].indexOf(new Integer(node2)); 			
 		}
 		return pos != -1;
 	}
 	
 	/**
 	 * Return a random node of a node neighborhood
 	 * @param node neighborhood of this node
 	 * @return node choosen
 	 */
 	public int chooseNeighbor(int node) {
 		int result = -1; 		
 		
 		if((node>=0)&&(node<lst.length)) {
			result = ((Integer)lst[node].get(RandomValue.integer(0,lst[node].size()-1))).intValue();
//			result = (int)lst[node].get(RandomValue.integer(0,lst[node].size()-1));
 		}
 		return result;
 	}
 	
 	/**
 	 * Return a string which represent the content of the list
 	 * @return String
 	 */
 	public String toString() {
 		String s = new String();
 		int i;
 		ListIterator ptr;
 		
 		for(i=0;i<lst.length;i++) {
 			s += i + ": ("; 			
 			ptr = lst[i].listIterator(0);
 			while(ptr.hasNext()) {
 				s += ptr.next();
 				if(ptr.hasNext()) s += ", ";
 			}
 			s += ")\n";
 		} 		
 		return s;
 	}
 }
