import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

class DASOR_VisuDialog extends DASOR_Dialog implements ItemListener
{
	private JCheckBox thirdDim;

	// CONSTRUCTOR
	public DASOR_VisuDialog(Frame owner,String title)
	{
		super(owner,title,true);
		father=(DASOR_Frame)owner;
		tail=father.net.getNbNodes();

		setBounds(40,40,400,400);
		setLayout(null);
		setResizable(false);

		pa=new JPanel[2];
		pa[0]=new JPanel();
		pa[1]=new JPanel();

		pa[0].setLayout( new	GridLayout(tail+1,4 ) );
		t=new JTextField [tail][3];

		sp=new JScrollPane( pa[0] ,ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED );
		sp.setBounds(10,10,370,300);
		sp.setBorder( BorderFactory.createRaisedBevelBorder() );


		for(int i=-1;i<tail ; i++ )
		{
			if( i!=-1)
				t[i]=new JTextField[3];
			for(int j=-1;j<3; j++ )
			{
				if(i==-1)
				{
					switch( j )
					{
						case -1:
							pa[0].add(new JLabel("----") );
							break;
						case 0:
							pa[0].add(new JLabel("X") );
							break;
						case 1:
							pa[0].add(new JLabel("Y") );
							break;
						case 2:
							thirdDim=new JCheckBox("Z");
							thirdDim.addItemListener(this);
							pa[0].add(thirdDim );
							break;
					}
				}
				else
				{
					switch( j )
					{
						case -1:
							pa[0].add(new JLabel("Node "+i) );
							break;
						case 0:
							t[i][j]=new JTextField( String.valueOf(father.net.getObjNode(i).getPos()[0])  );
							break;
						case 1:
							t[i][j]=new JTextField( String.valueOf(father.net.getObjNode(i).getPos()[1]) );
							break;
						default:
							t[i][j]=new JTextField( "__" );
							t[i][j].setEnabled(false);
							break;
					}

					if (j!=-1)
					{
						t[i][j].setColumns(2);
						t[i][j].setBounds(i*20,j*20,20,20);
						pa[0].add(t[i][j]);
					}
				}
			}
		}

		add(sp);
		Ok=new JButton("OK");
		Ok.addActionListener( this);



		pa[1].add(Ok);
		pa[1].setBorder( BorderFactory.createRaisedBevelBorder() );
		pa[1].setBounds(10,322,370,40);
		add(pa[1]);
		repaint();

	}

	public void itemStateChanged(ItemEvent e)
	{
		if ( e.getItemSelectable()==thirdDim )
			if( thirdDim.isSelected() )
				System.out.println("Z a ete choisi");
			else
				System.out.println("Z a ete deselectionn");

	}

	public void actionPerformed(ActionEvent e)
	{
		if(  "OK".equals( e.getActionCommand() ) )
		{
			for(int i=0;i<tail;i++)
			{
				father.net.getObjNode(i).setPosition( toDouble( t[i][0].getText()	) ,toDouble( t[i][1].getText() ) );
				father.net.SetPosLink(i);
			}

			dispose();

		}
	}

	//Converts  a String to a double
	public static double toDouble(String s)
	{
		double val=0;
		int j;

		if( s.indexOf('.') >0 )
			j= s.indexOf('.') -1 ;
		else
			j=s.length()-1;

		for(int i=0; i<s.length() ;i++)
		{
			if( i!= s.indexOf('.') )
			{
				switch( s.charAt(i) )
				{
					case '0':
						break;
					case '1':
						val+= 1 * Math.pow(10,j);
						break;
					case '2':
						val+= 2 * Math.pow(10,j);
						break;
					case '3':
						val+= 3 * Math.pow(10,j);
						break;
					case '4':
						val+= 4 * Math.pow(10,j);
						break;
					case '5':
						val+= 5 * Math.pow(10,j);
						break;
					case '6':
						val+= 6 * Math.pow(10,j);
						break;
					case '7':
						val+= 7 * Math.pow(10,j);
						break;
					case '8':
						val+= 8 * Math.pow(10,j);
						break;
					case '9':
						val+= 9 * Math.pow(10,j);
						break;

				}
				j-- ;
			}
		}
		return val;
	}
}
