import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;


public class DASOR_Tab extends JTabbedPane
{
	
	private DASOR_Frame father;


	/**
	 * The names of the 3 different panels.
	 */
	public static final String PanName[]={"GRAPH","TEXT","FORM"};
	
	
	/**
	 * The panels that this tabbedpane contains.
	 */
	protected DASOR_Panel pan[];
	
	
	/**
	 * Default constructor<br>
	 * Creates a tabbedpane specific to DASOR containing 3 panels.
	  * @param f the application that calls this constructor. 
	 */
	public DASOR_Tab(DASOR_Frame f)
	{
		super();
		father=f;
		
		pan=new DASOR_Panel[3];
		
		pan[0]=new DASOR_PanelGraph(father);
		pan[1]=new DASOR_PanelText(father);
		pan[2]=new DASOR_PanelVisu(father);
		
		for(int i=0;i<3;i++)
			addTab(PanName[i],pan[i]);
		
		addChangeListener( new DASOR_TabListener() );
		
	}//end of "public DASOR_Tab(DASOR_Frame f)"



	private class DASOR_TabListener implements ChangeListener
	{
		public void stateChanged(ChangeEvent e)
		{
			//System.out.println( PanName[getSelectedIndex()] );
			switch( getSelectedIndex() )
			{
				case 0: //GRAPM
					 ((Network) ((DASOR_PanelGraph)pan[0]).p[1] ).repaint();
					break;
				
				case 1: //TEXT
					pan[1].jt.setText( father.net.toText()+ "\n");
					break;
				
				case 2: //FORM
          ((DASOR_PanelVisu)pan[2]).nb.setText(String.valueOf(father.net.getNbNodes()));
					break;
				
			}
			father.Bar.Men[0].item[1].setEnabled(true);	
			
		}//end of "void stateChanged(ChangeEvent e)"
		
	}//end of "class DASOR_TabListener" 
}//end of "class DASOR_Tab"

