import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;

public class DASOR_Menu extends JMenu
{
	protected JMenuItem item[];
	private DASOR_Frame father;
	
	/**
	 * Constructor<br>
	 * Creates a menu specific to DASOR.
	 * @param name must be in {"File","Help","Network"}.
	 * @param fa the application that calls this menu. 
	 */
	public DASOR_Menu(String name,DASOR_Frame fa)
	{
		int i=0;
		father=fa;
		String intitule[]={"File","Help","Network"};
		while(i<3)
		{
			if( intitule[i].equals(name))
			{		createMenu(i);			}
			i++;
		}
	} //end of DASOR_Menu(String nom)
	
	
	
	/**
	 * Constructor
	 * Creates a menu specific to DASOR.
	 * @param i must be between 0 and 2 (0->File, 1->Help,2->Network)..
	 * @param fa the application that calls this menu. 
	 */
	public DASOR_Menu(int i,DASOR_Frame fa)
	{
		father=fa;
		//String intitule[]={"File","Help"};
		createMenu(i);
			
	} //end of DASOR_Menu(String nom)
	
	
	
	private void createMenu(int num)
	{
		/* num= 0 -> Fichier
		    	1 -> Aide
		*/
		switch(num)
		{
			case 0:
				item=new JMenuItem[4];
				setText("File");
				item[0]=new JMenuItem("Options");
				item[1]=new JMenuItem("Save");
				item[1].setMnemonic(KeyEvent.VK_S);
				KeyStroke  keys= KeyStroke.getKeyStroke(KeyEvent.VK_S , Event.CTRL_MASK);
				item[1].setAccelerator(keys);

				item[2]=new JMenuItem("Load");
				item[3]= new JMenuItem("Quit");
				item[1].setEnabled(false);
				item[0].addActionListener( new DASOR_Action_MenuFile() );
				item[1].addActionListener( new DASOR_Action_MenuFile() );
				item[2].addActionListener( new DASOR_Action_MenuFile() );
				item[3].addActionListener( new DASOR_Action_MenuFile() );
				add(item[0]);
				addSeparator();
				add(item[1]);
				add(item[2]);				
				addSeparator();
				add(item[3]);
				break;
			
			
			
			case 1:
				item=new JMenuItem[2];
				setText("Help");
				item[0]=new JMenuItem("Help");
				item[1]= new JMenuItem("About ...");
				item[0].addActionListener( new DASOR_Action_MenuHelp() );
			    item[1].addActionListener( new DASOR_Action_MenuHelp() );
		
				add(item[0]);
				add(item[1]);
				break;
				
			case 2:
				item=new JMenuItem[2];
				setText("Network");
				item[0]=new JMenuItem("Main Network");
				item[1]= new JMenuItem("Subnets");
	
				item[0].addActionListener( new DASOR_Action_MenuNet() );
				item[1].addActionListener( new DASOR_Action_MenuNet() );
		
				add(item[0]);
				add(item[1]);
				break;	
		}
	
	}//end of public void createMenu(int num)


	private class DASOR_Filter extends javax.swing.filechooser.FileFilter
	{
		public boolean accept(File obj)
		{
			String ext="";
			if(obj.getPath().lastIndexOf('.') >0 )
				ext= obj.getPath().substring( obj.getPath().lastIndexOf('.') +1).toLowerCase();
			
			if( ext!= "" )
				return ext.equals("net");
			else
			 return obj.isDirectory();
			
		}
		
		public String getDescription()
		{
			return "DASOR Network File (*.net)";
		}
	
	}



	private class DASOR_Action_MenuFile implements ActionListener
	{
		public void actionPerformed(ActionEvent e)
		{
			if( e.getSource()==item[0])
			{
				// Actions a faire apres un clic sur options
				System.out.println("Options");
			}
			
			if( e.getSource()==item[1] )
			{
				// Save clicked
				System.out.println("Save");
				JFileChooser filec=new JFileChooser(".");
				filec.addChoosableFileFilter(new DASOR_Filter() );
				filec.setDialogTitle("DASOR  -  Save");
				int ret=filec.showSaveDialog(null);
				if( ret== JFileChooser.APPROVE_OPTION )
				{
					String fname=new String(filec.getSelectedFile().getPath());
					
					String ext="";
					if( fname.lastIndexOf('.') >0 )
						ext=  fname.substring(  fname.lastIndexOf('.') +1).toLowerCase();
			
					System.out.println("ext="+ext);
				
					if( ext!= "" )
					{
						if( ext.equals("net") )
						{
							System.out.println(fname);
							NetworkFile.saveFile(father.net,fname);
						}
					}	
					else
						NetworkFile.saveFile(father.net,fname+".net");
				}
				
			}
			
			if( e.getSource()==item[2] )
			{
				// Load clicked
				System.out.println("Load");
			}
			
			if( e.getSource()==item[3] )
			{
				// Actions a faire pour une fermeture propre
				System.exit(0);
			}
		
		}//end of "public void actionPerformed(ActionEvent e)"	
	
	
	}//end of "class DASOR_Action_MenuFile"
	
	
	
	
	
	
	
	private class DASOR_Action_MenuHelp implements ActionListener
	{
		public void actionPerformed(ActionEvent e)
		{
			if( e.getSource()==item[0])
			{
				// Actions a faire apres un clic sur Help
				System.out.println("Help Page");
			
			}
			
			if( e.getSource()==item[1] )
			{
				// Actions a faire apres un clic sur A Propos
				System.out.println("About");
			}
		
		
		}//end of "public void actionPerformed(ActionEvent e)"	
	
	
	}//end of "class DASOR_Action_MenuHelp"
	
	
	
	
	private class DASOR_Action_MenuNet implements ActionListener
	{
		public void actionPerformed(ActionEvent e)
		{
			if( e.getSource()==item[0])
			{
				// Actions a faire apres un clic sur Reseaux principaux
				System.out.println("Main Network");
			
			}
			
			if( e.getSource()==item[1] )
			{
				// Actions a faire apres un clic sur Sous-Reseaux
				System.out.println("Subnets");
			}
		
		
		}//end of "public void actionPerformed(ActionEvent e)"	
	
	
	}//end of "class DASOR_Action_MenuNet"


}//end of class DASOR_Menu

