import java.awt.*;

class DASOR_Link
{
    private double posxd, posxf, posyd, posyf;
    private int weight;

 //////////////Constructeur////////////////
    DASOR_Link(double xd, double yd, double xf, double yf, int w)
    {
       this.posxd=xd;
       this.posyd=yd;
       this.posxf=xf;
       this.posyf=yf;
       this.weight=w;
    }

     DASOR_Link()
     {
       this.posxd=0;
       this.posxf=0;
       this.posyd=0;
       this.posyf=0;
       this.weight=0;
    }

//////////////Affichage///////////////////////
    public void Affiche(Graphics g, boolean valued)
    {
       g.drawLine((int)(posxd*Network.coefX), (int)(posyd*Network.coefY), (int)(posxf*Network.coefX), (int)(posyf*Network.coefY));

       if( valued )
       {
            g.setColor(Color.red);
            g.drawString("" + weight,(int)((posxd + (posxf-posxd)/2.0)*Network.coefX),(int)((posyd + (posyf-posyd)/2.0)*Network.coefY));
            g.setColor(Color.black);
       }
       
       double b=15.0;
       double h=10.0;
       double O = Math.atan( (posyf-posyd) / (posxf-posxd) );

       double Mx = 10.0 * Math.cos(O);
       double My = 10.0 * Math.sin(O);

       double Ax=( -h*Math.cos(O) - ( b/2.0)*Math.sin(O))-Mx;
       double Ay=( -h*Math.sin(O) + ( b/2.0)*Math.cos(O))-My;
       double Bx=( -h*Math.cos(O) - (-b/2.0)*Math.sin(O))-Mx;
       double By=( -h*Math.sin(O) + (-b/2.0)*Math.cos(O))-My;

       if (posxd*Network.coefX>posxf*Network.coefX)
        {
          Ax=-Ax;
          Ay=-Ay;
          Bx=-Bx;
          By=-By;
       g.drawLine((int)(posxf*Network.coefX+Ax), (int)(posyf*Network.coefY+Ay), (int)(posxf*Network.coefX+Mx), (int)(posyf*Network.coefY+My));
       g.drawLine((int)(posxf*Network.coefX+Bx), (int)(posyf*Network.coefY+By), (int)(posxf*Network.coefX+Mx), (int)(posyf*Network.coefY+My));
        }
       else
       {
       g.drawLine((int)(posxf*Network.coefX+Ax), (int)(posyf*Network.coefY+Ay), (int)(posxf*Network.coefX-Mx), (int)(posyf*Network.coefY-My));
       g.drawLine((int)(posxf*Network.coefX+Bx), (int)(posyf*Network.coefY+By), (int)(posxf*Network.coefX-Mx), (int)(posyf*Network.coefY-My));
       }
      }
      
/////////////Getters/////////////
public double getXend() { return posxf;}
public double getYend() { return posyf;}
public double getXstart() { return posxd;}
public double getYstart() { return posyd;}
public int getWeight() { return weight;}


////////////Setters////////////////
public void setPos(double xd, double yd, double xf, double yf)
{
  posxd=xd;
  posyd=yd;
  posxf=xf;
  posyf=yf;
}

public void setPosStart(double x, double y)
{
  posxd=x;
  posyd=y;
}

public void setPosEnd(double x, double y)
{
  posxf=x;
  posyf=y;
}

public void setWeight(int w)
{
  weight=w;
}

}//Fin de la classe
