public class DASOR_AdjMatrix
{
	// Size of the matrix
	private int size;
	// Matrix
	private DASOR_Link[][] matrix;

	//
	// CONSTRUCTOR(S)
	//

	/**
	 * Default constructor
	 * @param size is the size of the matrix
	 */
	public DASOR_AdjMatrix(int size)
  {
		this.size = size;
		matrix = new DASOR_Link[size][size];
		empty();
	}

	//
	// GETTERS
	//

	/**
	 * Return the size
	 * @return size of the matrix
	 */
	public int getSize()
    {
		return this.size;
	}


	/**
	 * Return the weight between node 1 and node 2. Return 0 if there's no link between the nodes
	 * @param node1 the first node
	 * @param node2 the second node
	 * @result the weight between the two nodes
	 */
	public int getWeight(int node1, int node2)
    {
		int weight = 0;

		if((node1>=0)&&(node1<size)&&(node2>=0)&&(node2<size))
        {
			weight = (matrix[node1][node2]).getWeight();
		}
		return weight;
	}


  public DASOR_Link getLink(int node1, int node2)
   {
     return matrix[node1][node2];
   }

  public DASOR_Link getLinkClicked(double x, double y)
   {
     double middleX, middleY;
     for(int i=0; i<size; i++)
       for(int j=0; j<size; j++)
        {
          if (i!=j && matrix[i][j].getWeight()>0 )
            {
              middleX= matrix[i][j].getXstart()+ (matrix[i][j].getXend() - matrix[i][j].getXstart())/2.0;
              middleY= matrix[i][j].getYstart()+ (matrix[i][j].getYend() - matrix[i][j].getYstart())/2.0;
              if ( x>=middleX-10.0/Network.coefX && x<=middleX+10.0/Network.coefX && y>=middleY-10.0/Network.coefX && y<=middleY+10.0/Network.coefY )
                return matrix[i][j];
            }
        }
      return null;
   }


	//
	// SETTERS
	//

	/**
	 * Set a weight between two nodes
	 * @param node1 first node
	 * @param node2 second node
	 * @param weight the weight
	 */
	public void setWeight(int node1, int node2, int weight)
  {
		if((node1>=0)&&(node1<size)&&(node2>=0)&&(node2<size))
    {
			matrix[node1][node2].setWeight(weight);
		}
	}

  public void setPos(DASOR_Node node1, DASOR_Node node2)
  {
      matrix[node1.getNum()][node2.getNum()].setPos(node1.getX()+10.0/Network.coefX,node1.getY()+10.0/Network.coefY,node2.getX()+10.0/Network.coefX,node2.getY()+10.0/Network.coefY);

 	}

	//
	// OTHER METHODS
	//
	
	public void addNode()
	{
    DASOR_Link[][] tmp;
    tmp = matrix;
    matrix = new DASOR_Link[size+1][size+1];
    for(int i=0; i<size; i++)
      for(int j=0; j<size; j++)
         matrix[i][j] = tmp[i][j];
    size++;
    for(int k=0; k<(size-1); k++)
    {
      matrix[size-1][k] = new DASOR_Link(0,0,0,0,0);
      matrix[k][size-1] = new DASOR_Link(0,0,0,0,0);
    }
    matrix[size-1][size-1] = new DASOR_Link(0,0,0,0,1);
 }
	
	
	/**
	 * Return true if a link exists between the node1 and the node2,
	 * false otherwise.
	 * @param node1 first node
	 * @param node2 second node
	 */
 public boolean isLink(int node1, int node2)
 {
   return ((matrix[node1][node2].getWeight())>0);
 }
	
	/**
	 * Delete the node.
	 * @param node : the node to be deleted.
	 */
 public void delNode(int node)
 {
    System.out.println("ok2");
    DASOR_Link[][] tmp;
    tmp = matrix;
    matrix = new DASOR_Link[size-1][size-1];
    for(int i=0; i<size; i++)
      for(int j=0; j<size; j++)
         {
           if ( i != node && j!=node )
            {
              if ( i<node && j<node )
                matrix[i][j] = tmp[i][j];
              else if ( i>node && j>node )
                     matrix[i-1][j-1] = tmp[i][j];
                   else if ( i<node && j>node )
                          matrix[i][j-1] = tmp[i][j];
                        else if ( i>node && j<node )
                          matrix[i-1][j] = tmp[i][j];
            }
         }
    size--;
 }
 
 
	/**
	 * Empty the matrix
	 */
	public void empty() {
		int i,j;

		for(i=0;i<size;i++)
			for(j=0;j<size;j++) {
				if(i!=j)
					matrix[i][j]=new DASOR_Link(0,0,0,0,0);
				else
					matrix[i][j]=new DASOR_Link(0,0,0,0,1);
			}
	}

	/**
	 * Return a string which contains the matrix
	 * @return string
	 */
	public String toString() {
		String s = new String();
		int i,j;

		s = "[";
		for(i=0;i<size;i++) {
			if(i>0)
				s += " [";
			else
				s += "[";
			for(j=0;j<size;j++) {
				if(j<size-1)
					s += matrix[i][j].getWeight()+", ";
				else
					s += matrix[i][j].getWeight();
			}
			s += "]";
			if(i<size-1) s += "\n";
		}
		s += "]";
		return s;
	}
}
